/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.transformer;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.annotations.param.Payload;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.config.expression.ExpressionAnnotationsHelper;
import org.mule.config.i18n.AnnotationsMessages;
import org.mule.config.transformer.TransformerArgumentResolver;
import org.mule.expression.transformers.ExpressionTransformer;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformer.types.SimpleDataType;
import org.mule.transport.NullPayload;
import org.mule.util.annotation.AnnotationUtils;

public class AnnotatedTransformerProxy
extends AbstractMessageTransformer
implements DiscoverableTransformer {
    private int weighting;
    private Object proxy;
    private Method transformMethod;
    private boolean messageAware = false;
    private ExpressionTransformer paramTransformer = null;
    private Collection<TransformerArgumentResolver> resolvers;
    private Map<Class<?>, Object> cachedObjects = new WeakHashMap();
    private boolean sourceAnnotated = false;

    public AnnotatedTransformerProxy(int weighting, Object proxy, Method transformMethod, Class[] additionalSourceTypes, String sourceMimeType, String resultMimeType) throws TransformerException, InitialisationException {
        this.weighting = weighting;
        this.proxy = proxy;
        this.validateMethod(transformMethod, additionalSourceTypes);
        this.transformMethod = transformMethod;
        this.setReturnDataType(DataTypeFactory.createFromReturnType(transformMethod));
        this.messageAware = MuleMessage.class.isAssignableFrom(transformMethod.getParameterTypes()[0]);
        this.transformMethod = transformMethod;
        if (additionalSourceTypes.length > 0) {
            if (this.messageAware) {
                this.logger.error((Object)("Transformer: " + this.getName() + " is MuleMessage aware, this means additional source types configured on the transformer will be ignorred. Source types are: " + Arrays.toString(additionalSourceTypes)));
            } else {
                for (int i = 0; i < additionalSourceTypes.length; ++i) {
                    this.registerSourceType(new SimpleDataType(additionalSourceTypes[i], sourceMimeType));
                }
            }
        }
        Class<?> source = transformMethod.getParameterTypes()[0];
        this.registerSourceType(source);
        this.sourceAnnotated = transformMethod.getParameterAnnotations()[0].length > 0 && transformMethod.getParameterAnnotations()[0][0] instanceof Payload;
        this.setName(proxy.getClass().getSimpleName() + "." + transformMethod.getName());
    }

    protected void validateMethod(Method method, Class[] sourceTypes) throws IllegalArgumentException {
        int mods = method.getModifiers();
        if (Modifier.isAbstract(mods) || Modifier.isInterface(mods) || !Modifier.isPublic(mods) || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length == 0 || method.getReturnType().equals(Object.class) || Arrays.asList(method.getParameterTypes()).contains(Object.class) || Arrays.asList(sourceTypes).contains(Object.class)) {
            throw new IllegalArgumentException(AnnotationsMessages.transformerMethodNotValid(method).getMessage());
        }
    }

    public void initialise() throws InitialisationException {
        super.initialise();
        if (AnnotationUtils.methodHasParamAnnotations(this.transformMethod)) {
            try {
                this.paramTransformer = ExpressionAnnotationsHelper.getTransformerForMethodWithAnnotations(this.transformMethod, this.muleContext);
            }
            catch (TransformerException e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
        this.resolvers = this.muleContext.getRegistry().lookupObjects(TransformerArgumentResolver.class);
    }

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        MuleMessage firstArg = null;
        Object[] params = new Object[this.transformMethod.getParameterTypes().length];
        int paramCounter = 0;
        if (this.paramTransformer != null) {
            Object paramArgs = this.paramTransformer.transformMessage(message, outputEncoding);
            if (paramArgs != null && paramArgs.getClass().isArray()) {
                Object[] temp = (Object[])paramArgs;
                if (!this.sourceAnnotated) {
                    ++paramCounter;
                }
                for (int i = 0; i < temp.length; ++i) {
                    params[paramCounter++] = temp[i];
                }
            } else {
                if (!this.sourceAnnotated) {
                    // empty if block
                }
                int n = ++paramCounter;
                ++paramCounter;
                params[n] = paramArgs;
            }
        }
        if (this.messageAware) {
            firstArg = message;
        } else if (!this.sourceAnnotated) {
            try {
                firstArg = message.getPayload(DataTypeFactory.create(this.transformMethod.getParameterTypes()[0]));
            }
            catch (TransformerException e) {
                throw new TransformerException(e.getI18nMessage(), this, (Throwable)e);
            }
        }
        if (!this.sourceAnnotated) {
            params[0] = firstArg;
            if (paramCounter == 0) {
                ++paramCounter;
            }
        }
        if (paramCounter < this.transformMethod.getParameterTypes().length) {
            for (int i = paramCounter; i < this.transformMethod.getParameterTypes().length; ++i) {
                Class<?> type = this.transformMethod.getParameterTypes()[i];
                Object o = this.cachedObjects.get(type);
                if (o != null) {
                    params[paramCounter++] = o;
                    continue;
                }
                DataType source = DataTypeFactory.createFromParameterType(this.transformMethod, 0);
                for (TransformerArgumentResolver resolver : this.resolvers) {
                    try {
                        o = resolver.resolve(type, source, this.returnType, this.muleContext);
                        if (o == null) continue;
                        params[paramCounter++] = o;
                        this.cachedObjects.put(type, o);
                        break;
                    }
                    catch (Exception e) {
                        throw new TransformerException(this, (Throwable)e);
                    }
                }
                if (o != null) continue;
                throw new IllegalArgumentException("Failed to find resolver for object type: " + type + " for transform method: " + this.transformMethod);
            }
        }
        try {
            return this.transformMethod.invoke(this.proxy, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TransformerException(this, (Throwable)e);
        }
    }

    public int getPriorityWeighting() {
        return this.weighting;
    }

    public void setPriorityWeighting(int weighting) {
        throw new UnsupportedOperationException("setPriorityWeighting");
    }

    protected Object checkReturnClass(Object object, MuleEvent event) throws TransformerMessagingException {
        if (object instanceof NullPayload) {
            return null;
        }
        return super.checkReturnClass(object, event);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotatedTransformerProxy that = (AnnotatedTransformerProxy)o;
        if (this.messageAware != that.messageAware) {
            return false;
        }
        if (this.weighting != that.weighting) {
            return false;
        }
        if (this.proxy != null ? !this.proxy.equals(that.proxy) : that.proxy != null) {
            return false;
        }
        return !(this.transformMethod != null ? !this.transformMethod.equals(that.transformMethod) : that.transformMethod != null);
    }

    public int hashCode() {
        int result = this.weighting;
        result = 31 * result + (this.proxy != null ? this.proxy.hashCode() : 0);
        result = 31 * result + (this.transformMethod != null ? this.transformMethod.hashCode() : 0);
        result = 31 * result + (this.messageAware ? 1 : 0);
        return result;
    }
}

