/*
 * $Id: MockAgent.java 18727 2010-08-02 19:26:55Z rossmason $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.agent;

import org.mule.api.MuleException;
import org.mule.api.agent.Agent;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.util.ClassUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MockAgent extends Object implements Agent
{
    private String name;
    private List dependencies = Collections.EMPTY_LIST;
    
    public MockAgent()
    {
        super();
    }
    
    public MockAgent(Class[] classes)
    {
        super();
        dependencies = Arrays.asList(classes);
    }

    public List<Class<? extends Agent>> getDependentAgents()
    {
        return dependencies;
    }

    public String getDescription()
    {
        return ClassUtils.getSimpleName(this.getClass());
    }

    public void initialise() throws InitialisationException
    {
        // nothing to do
    }

    public void start() throws MuleException
    {
        // nothing to do
    }

    public void stop() throws MuleException
    {
        // nothing to do
    }

    public void dispose()
    {
        // nothing to do
    }

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public boolean isInitialised()
    {
        return false;
    }

    public boolean isStarted()
    {
        return false;
    }

    public boolean isStopped()
    {
        return false;
    }

    public boolean isDisposed()
    {
        return false;
    }
}


