/*
 * $Id: ServerNotificationHandler.java 17050 2010-04-20 02:52:45Z dfeist $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.api.context.notification;


public interface ServerNotificationHandler
{
    void fireNotification(ServerNotification notification);

    boolean isNotificationDynamic();

    /**
     *
     * @param listener
     * @return
     *
     * @since 3.0
     */
    boolean isListenerRegistered(ServerNotificationListener listener);

    /**
     * This returns a very "conservative" value - it is true if the notification or any subclass would be
     * accepted.  So if it returns false then you can be sure that there is no need to send the
     * notification.  On the other hand, if it returns true there is no guarantee that the notification
     * "really" will be dispatched to any listener.
     *
     * @param notfnClass Either the notification class being generated or some superclass
     * @return false if there is no need to dispatch the notification
     */
    boolean isNotificationEnabled(Class<? extends ServerNotification> notfnClass);

}
