/*
 * $Id: ReplyToHandler.java 17128 2010-04-28 14:54:25Z dirk.olmes $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.api.transport;

import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;

import java.util.List;

/**
 * <code>ReplyToHandler</code> is used to handle routing where a replyTo endpointUri is
 * set on the message
 */

public interface ReplyToHandler
{
    void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException;

    void setTransformers(List<Transformer> transformers);

    List<Transformer> getTransformers();
}
