/*
 * $Id: Application.java 18767 2010-08-03 19:12:23Z aperepel $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.module.launcher;

import org.mule.api.MuleContext;

public interface Application
{
    void install() throws InstallException;

    void init();

    void start() throws DeploymentStartException;

    void stop();

    void dispose();

    void redeploy();

    MuleContext getMuleContext();

    /**
     * @return a classloader associated with this deployment 
     */
    ClassLoader getDeploymentClassLoader();

    String getAppName();
}
