/*
 * $Id: QuietExceptionStrategy.java 18928 2010-08-11 12:38:35Z tcarlson $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tck.functional;

import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.exception.AbstractMessagingExceptionStrategy;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Restrict exceptions to debug log messages
 */
public class QuietExceptionStrategy extends AbstractMessagingExceptionStrategy
{
    protected transient Log logger = LogFactory.getLog(getClass());

    @Override
    public void handleMessagingException(MuleMessage message, Throwable e)
    {
        logger.debug("Ignoring", e);
    }

    @Override
    public void handleRoutingException(MuleMessage message, MessageProcessor target, Throwable e)
    {
        logger.debug("Ignoring", e);
    }

    @Override
    public void handleLifecycleException(Object component, Throwable e)
    {
        logger.debug("Ignoring", e);
    }

    @Override
    public void handleStandardException(Throwable e)
    {
        logger.debug("Ignoring", e);
    }

    @Override
    protected void logException(Throwable t)
    {
        logger.debug("Ignoring", t);
    }
}
