<%@ page import="org.mule.example.loanbroker.esn.LoanBrokerApp,
                 org.mule.example.loanbroker.messages.Customer,
                 org.mule.example.loanbroker.messages.CustomerQuoteRequest,
                 org.mule.module.client.MuleClient,
                 org.mule.api.MuleMessage,
                 java.util.Iterator,
                 java.util.List"%>
<%@ page import="org.mule.api.config.MuleProperties" %>
<%@ page import="org.mule.api.MuleContext" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" %>

<html>
<head>
<title>Mule Loan Broker Example</title>
</head>
<body>
<%
    String amountString = request.getParameter("amount");
    String durationString = request.getParameter("duration");
    String name = request.getParameter("name");
    String random = request.getParameter("random");

    if(random!=null) {
        LoanBrokerApp consumer = new LoanBrokerApp();
        int requests = Integer.parseInt(random);
        //to get all the result and print them out
        List results = consumer.requestSend(requests, "CustomerRequests");
        %>
        <b>You have just made <%=requests%> Loan Requests!</b>
        <ol>
        <% for(Iterator iter = results.iterator(); iter.hasNext();) {
            %><li><%=iter.next().toString()%></li><%
        }%>
        </ol>

        <%
    } else if(amountString!=null && durationString!=null && name!=null) {
        MuleContext muleContext = (MuleContext) application.getAttribute(MuleProperties.MULE_CONTEXT_PROPERTY);
        MuleClient client = new MuleClient(muleContext);
        Customer cust = new Customer(name, 1234);
        double amount = Double.valueOf(amountString).doubleValue();
        int duration = Integer.parseInt(durationString);
        CustomerQuoteRequest loanRequest = new CustomerQuoteRequest(cust, amount,  duration);
        MuleMessage message = client.send("CustomerRequests", loanRequest, null);
        %>
<h3>The best quote was received from: <br/> <%=message.getPayload()%></h3>
     <%} else {%>
<form method="POST" name="submitRequest" action="">
    Send 10 random requests:
    <table>
        <tr><td>
            <input type="hidden" name="random" value="10"/><input type="submit" name="submit" value="Submit" />
        </td></tr>
    </table>
</form>
<br/>- Or -<br/>
<form method="POST" name="submitRequest" action="">
    Please enter your Loan Details:
    <table>
        <tr><td>Name: </td><td>
            <input type="text" name="name"/>
        </td></tr>
        <tr><td>Amount: </td><td>
            <input type="text" name="amount"/>
        </td></tr>
        <tr><td>Duration: </td><td>
            <input type="text" name="duration"/>
        </td></tr>

        <tr><td colspan="2">
            <input type="submit" name="submit" value="Submit" />
        </td></tr>
    </table>
</form>
<%}%>

<p/>
<table border="1" bordercolor="#990000"  align="left">
<tr><td>For more information about Loan Broker example go <a target="_blank" href="http://mule.mulesource.org/display/MULE2INTRO/Loan+Broker+Example">here</a>.</td></tr>
</table>
</body>
</html>
