/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.filters;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;

public class IsJsonFilter
implements Filter {
    protected final transient Log logger = LogFactory.getLog(IsJsonFilter.class);
    private boolean validateParsing = false;

    public boolean accept(MuleMessage obj) {
        String contentType = obj.getOutboundProperty("Content-Type", "");
        if (contentType.contains("application/json")) {
            return true;
        }
        try {
            return this.accept(obj.getPayloadAsString());
        }
        catch (Exception e) {
            this.logger.warn((Object)"Failed to read object payload as string for isJsonFilter", (Throwable)e);
            return false;
        }
    }

    public boolean accept(Object obj) {
        try {
            if (obj instanceof byte[]) {
                obj = new String((byte[])obj);
            }
            if (obj instanceof String) {
                if (!this.mayBeJSON((String)obj)) {
                    return false;
                }
                if (this.isValidateParsing()) {
                    new ObjectMapper().readTree((String)obj);
                }
                return true;
            }
            return false;
        }
        catch (IOException e) {
            this.logger.error((Object)("Filter result = false (message is not valid JSON): " + e.getMessage()));
            return false;
        }
    }

    public boolean isValidateParsing() {
        return this.validateParsing;
    }

    public void setValidateParsing(boolean validateParsing) {
        this.validateParsing = validateParsing;
    }

    protected boolean mayBeJSON(String string) {
        return string != null && ("null".equals(string) || string.startsWith("[") && string.endsWith("]") || string.startsWith("{") && string.endsWith("}"));
    }
}

