/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.factories;

import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.NamedObject;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.MuleContextAware;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.processor.AsyncInterceptingMessageProcessor;
import org.mule.processor.builder.InterceptingChainMessageProcessorBuilder;
import org.springframework.beans.factory.FactoryBean;

public class AsyncMessageProcessorsFactoryBean
implements FactoryBean,
MuleContextAware,
NamedObject {
    protected MuleContext muleContext;
    protected List messageProcessors;
    protected ThreadingProfile threadingProfile = ThreadingProfile.DEFAULT_THREADING_PROFILE;
    protected String name;

    public Class getObjectType() {
        return MessageProcessor.class;
    }

    public void setThreadingProfile(ThreadingProfile threadingProfile) {
        this.threadingProfile = threadingProfile;
    }

    public void setMessageProcessors(List messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public Object getObject() throws Exception {
        InterceptingChainMessageProcessorBuilder builder = new InterceptingChainMessageProcessorBuilder();
        AsyncInterceptingMessageProcessor asyncProcessor = new AsyncInterceptingMessageProcessor(this.threadingProfile, this.name, this.muleContext.getConfiguration().getShutdownTimeout());
        builder.chain(asyncProcessor);
        for (Object processor : this.messageProcessors) {
            if (processor instanceof MessageProcessor) {
                builder.chain((MessageProcessor)processor);
                continue;
            }
            if (processor instanceof MessageProcessorBuilder) {
                builder.chain((MessageProcessorBuilder)processor);
                continue;
            }
            throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
        }
        return builder.build();
    }

    public boolean isSingleton() {
        return false;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

