/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.generic;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import org.mule.util.StringUtils;
import org.w3c.dom.Element;

public class AutoIdUtils {
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_NAME = "name";
    private static final AtomicInteger counter = new AtomicInteger(0);
    public static final String PREFIX = "org.mule.autogen.";

    public static boolean blankAttribute(Element element, String attribute) {
        return StringUtils.isBlank((String)element.getAttribute(attribute));
    }

    public static void ensureUniqueId(Element element, String type) {
        if (null != element && AutoIdUtils.blankAttribute(element, ATTRIBUTE_ID)) {
            if (AutoIdUtils.blankAttribute(element, ATTRIBUTE_NAME)) {
                element.setAttribute(ATTRIBUTE_ID, AutoIdUtils.uniqueValue(PREFIX + type));
            } else {
                element.setAttribute(ATTRIBUTE_ID, element.getAttribute(ATTRIBUTE_NAME));
            }
        }
    }

    public static String getUniqueName(Element element, String type) {
        if (!AutoIdUtils.blankAttribute(element, ATTRIBUTE_NAME)) {
            return element.getAttribute(ATTRIBUTE_NAME);
        }
        if (!AutoIdUtils.blankAttribute(element, ATTRIBUTE_ID)) {
            return element.getAttribute(ATTRIBUTE_ID);
        }
        return AutoIdUtils.uniqueValue(PREFIX + type);
    }

    public static String uniqueValue(String value) {
        return value + "." + counter.incrementAndGet();
    }

    public static void forceUniqueId(Element element, String type) {
        if (null != element) {
            String id = AutoIdUtils.uniqueValue(PREFIX + type);
            element.setAttribute(ATTRIBUTE_ID, id);
            element.setAttribute(ATTRIBUTE_NAME, id);
        }
    }
}

