/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.spring.parsers.processors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.mule.config.spring.parsers.PreProcessor;
import org.mule.config.spring.parsers.assembly.configuration.PropertyConfiguration;
import org.mule.config.spring.util.SpringXMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckExclusiveAttributes
implements PreProcessor {
    private Collection<AttributeSet> attributeSets = new ArrayList<AttributeSet>();

    public CheckExclusiveAttributes(String[][] attributeNames) {
        for (int i = 0; i < attributeNames.length; ++i) {
            String[] attributes = attributeNames[i];
            this.attributeSets.add(new AttributeSet(attributes));
        }
    }

    @Override
    public void preProcess(PropertyConfiguration config, Element element) {
        Collection<AttributeSet> allMatchingSets = new ArrayList<AttributeSet>(this.attributeSets);
        boolean atLeastOneAttributeDidMatch = false;
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            String alias = SpringXMLUtils.attributeName((Attr)attributes.item(i));
            if (this.isOptionalAttribute(alias)) continue;
            allMatchingSets = this.filterMatchingSets(allMatchingSets, alias);
            atLeastOneAttributeDidMatch = true;
        }
        if (atLeastOneAttributeDidMatch && allMatchingSets.size() == 0) {
            CheckExclusiveAttributesException ex = CheckExclusiveAttributesException.createForDisjunctGroups(element, this.attributeSets);
            throw ex;
        }
        if (atLeastOneAttributeDidMatch && allMatchingSets.size() > 1) {
            CheckExclusiveAttributesException ex = CheckExclusiveAttributesException.createForInsufficientAttributes(element, allMatchingSets);
            throw ex;
        }
    }

    private Collection<AttributeSet> filterMatchingSets(Collection<AttributeSet> allMatchingSets, String attributeName) {
        ArrayList<AttributeSet> newMatchingSets = new ArrayList<AttributeSet>();
        for (AttributeSet currentSet : allMatchingSets) {
            if (!currentSet.containsAttribute(attributeName)) continue;
            newMatchingSets.add(currentSet);
        }
        return newMatchingSets;
    }

    private boolean isOptionalAttribute(String name) {
        return this.findMatchingAttributeSets(name).size() == 0;
    }

    private Collection<AttributeSet> findMatchingAttributeSets(String alias) {
        ArrayList<AttributeSet> matchingSets = new ArrayList<AttributeSet>();
        for (AttributeSet currentSet : this.attributeSets) {
            if (!currentSet.containsAttribute(alias)) continue;
            matchingSets.add(currentSet);
        }
        return matchingSets;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CheckExclusiveAttributesException
    extends IllegalStateException {
        public static CheckExclusiveAttributesException createForDisjunctGroups(Element element, Collection<AttributeSet> allMatchingSets) {
            String message = CheckExclusiveAttributesException.createMessage(element, allMatchingSets);
            return new CheckExclusiveAttributesException(message);
        }

        private static String createMessage(Element element, Collection<AttributeSet> allMatchingSets) {
            StringBuilder buf = new StringBuilder("The attributes of Element ");
            buf.append(SpringXMLUtils.elementToString(element));
            buf.append(" do not match the exclusive groups");
            for (AttributeSet match : allMatchingSets) {
                buf.append(" ");
                buf.append(match.toString());
            }
            return buf.toString();
        }

        public static CheckExclusiveAttributesException createForInsufficientAttributes(Element element, Collection<AttributeSet> attributeSets) {
            StringBuilder buf = new StringBuilder("Attributes of Element ");
            buf.append(SpringXMLUtils.elementToString(element));
            buf.append(" do not satisfy the exclusive groups");
            for (AttributeSet attributeSet : attributeSets) {
                buf.append(" ");
                buf.append(attributeSet);
            }
            buf.append(".");
            return new CheckExclusiveAttributesException(buf.toString());
        }

        private CheckExclusiveAttributesException(String message) {
            super(message);
        }
    }

    private static class AttributeSet {
        private String[] attributeNames;

        public AttributeSet(String[] attributeNames) {
            this.attributeNames = attributeNames;
        }

        public boolean containsAttribute(String name) {
            for (int i = 0; i < this.attributeNames.length; ++i) {
                String element = this.attributeNames[i];
                if (!element.equals(name)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return Arrays.toString(this.attributeNames);
        }
    }
}

