/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.util.ArrayList;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.dom.TextOverAttrInfo;
import net.sf.saxon.dom.TypeInfoImpl;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class AttrOverNodeInfo
extends NodeOverNodeInfo
implements Attr {
    public String getName() {
        if (this.node.getNodeKind() == 13) {
            String string = this.node.getLocalPart();
            if (string.equals("")) {
                return "xmlns";
            }
            return "xmlns:" + string;
        }
        return this.node.getDisplayName();
    }

    public String getValue() {
        return this.node.getStringValue();
    }

    public boolean hasChildNodes() {
        return true;
    }

    public Node getFirstChild() {
        return new TextOverAttrInfo(this);
    }

    public Node getLastChild() {
        return this.getFirstChild();
    }

    public NodeList getChildNodes() {
        ArrayList<Node> arrayList = new ArrayList<Node>(1);
        arrayList.add(this.getFirstChild());
        return new DOMNodeList(arrayList);
    }

    public boolean getSpecified() {
        return true;
    }

    public void setValue(String string) throws DOMException {
        AttrOverNodeInfo.disallowUpdate();
    }

    public boolean isId() {
        ContentTypeTest contentTypeTest = new ContentTypeTest(2, (SchemaType)BuiltInAtomicType.ID, this.node.getConfiguration());
        contentTypeTest.setMatchDTDTypes(true);
        return contentTypeTest.matches(this.node);
    }

    public Element getOwnerElement() {
        if (this.node.getNodeKind() == 2 || this.node.getNodeKind() == 13) {
            return (Element)((Object)AttrOverNodeInfo.wrap(this.node.getParent()));
        }
        throw new UnsupportedOperationException("This method is defined only on attribute and namespace nodes");
    }

    public TypeInfo getSchemaTypeInfo() {
        int n = this.node.getTypeAnnotation();
        if (n == -1 || (n & 0x40000000) != 0) {
            return null;
        }
        return new TypeInfoImpl(this.node.getConfiguration(), this.node.getConfiguration().getSchemaType(n));
    }
}

