/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.api;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessEngine;
import org.xml.sax.InputSource;

public class Configuration {
    static Map<String, String> implementationClassNames = null;
    transient Configuration impl;
    private static ProcessEngine cachedProcessEngine;

    public Configuration() {
        this((String)null);
    }

    public Configuration(String type) {
        String implementationClassName = this.getImplementationClassName(type);
        if (implementationClassName == null) {
            throw new JbpmException("type is null");
        }
        this.impl = this.instantiate(implementationClassName);
    }

    protected Configuration(Configuration base) {
    }

    private synchronized String getImplementationClassName(String type) {
        String implementationClassName;
        if (implementationClassNames == null) {
            implementationClassNames = new HashMap<String, String>();
            implementationClassNames.put(null, "org.jbpm.pvm.internal.cfg.ProcessEngineImpl");
            implementationClassNames.put("spring-test", "org.jbpm.pvm.internal.cfg.SpringConfiguration");
        }
        if ((implementationClassName = implementationClassNames.get(type)) == null) {
            implementationClassName = type;
        }
        return implementationClassName;
    }

    protected Configuration instantiate(String className) {
        Configuration implementation;
        try {
            Class<?> implementationClass = Class.forName(className, true, this.getClassLoader());
            implementation = (Configuration)implementationClass.newInstance();
        }
        catch (Exception e) {
            throw new JbpmException("couldn't instantiate configuration of type " + className, e);
        }
        return implementation;
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public Configuration setXmlString(String xmlString) {
        this.impl.setXmlString(xmlString);
        return this.impl;
    }

    public Configuration setResource(String resource) {
        this.impl.setResource(resource);
        return this.impl;
    }

    public Configuration setInputStream(InputStream inputStream) {
        this.impl.setInputStream(inputStream);
        return this.impl;
    }

    public Configuration setInputSource(InputSource inputSource) {
        this.impl.setInputSource(inputSource);
        return this.impl;
    }

    public Configuration setUrl(URL url) {
        this.impl.setUrl(url);
        return this.impl;
    }

    public Configuration setFile(File file) {
        this.impl.setFile(file);
        return this.impl;
    }

    public ProcessEngine buildProcessEngine() {
        return this.impl.buildProcessEngine();
    }

    public Configuration setHibernateSessionFactory(Object hibernateSessionFactory) {
        return this.impl.setHibernateSessionFactory(hibernateSessionFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProcessEngine getProcessEngine() {
        if (cachedProcessEngine != null) return cachedProcessEngine;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (cachedProcessEngine != null) return cachedProcessEngine;
            cachedProcessEngine = new Configuration().setResource("jbpm.cfg.xml").buildProcessEngine();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cachedProcessEngine;
        }
    }
}

