/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.dsa;

import cryptix.jce.provider.dsa.SignatureData;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public final class RawDSASignature
extends SignatureSpi {
    private BigInteger ZERO = BigInteger.valueOf(0L);
    private BigInteger x;
    private BigInteger y;
    private BigInteger g;
    private BigInteger p;
    private BigInteger q;
    private final byte[] buf = new byte[20];
    private int bufPtr;
    private SecureRandom random;

    public RawDSASignature() {
        this.burn();
    }

    private void burn() {
        this.q = null;
        this.p = null;
        this.g = null;
        this.y = null;
        this.x = null;
        this.bufPtr = 0;
        int i = 0;
        while (i < this.buf.length) {
            this.buf[i] = 0;
            ++i;
        }
    }

    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException("This algorithm does not have parameters.");
    }

    protected void engineInitSign(PrivateKey key) throws InvalidKeyException {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.engineInitSign(key, this.random);
    }

    protected void engineInitSign(PrivateKey key, SecureRandom random) throws InvalidKeyException {
        this.burn();
        if (!(key instanceof DSAPrivateKey)) {
            throw new InvalidKeyException("Not a DSA private key");
        }
        DSAPrivateKey dsa = (DSAPrivateKey)key;
        this.x = dsa.getX();
        DSAParams params = dsa.getParams();
        this.g = params.getG();
        this.p = params.getP();
        this.q = params.getQ();
        this.random = random;
        if (!this.validate()) {
            this.burn();
            throw new InvalidKeyException("Invalid key values");
        }
    }

    protected void engineInitVerify(PublicKey key) throws InvalidKeyException {
        this.burn();
        if (!(key instanceof DSAPublicKey)) {
            throw new InvalidKeyException("Not a DSA public key");
        }
        DSAPublicKey dsa = (DSAPublicKey)key;
        this.y = dsa.getY();
        DSAParams params = dsa.getParams();
        this.g = params.getG();
        this.p = params.getP();
        this.q = params.getQ();
        if (!this.validate()) {
            this.burn();
            throw new InvalidKeyException("Invalid key values");
        }
    }

    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException("This algorithm does not accept parameters.");
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("This algorithm does not accept AlgorithmParameterSpec.");
    }

    protected byte[] engineSign() throws SignatureException {
        BigInteger s;
        BigInteger r;
        if (this.bufPtr != 20) {
            throw new SignatureException("Insufficient data for signature");
        }
        BigInteger data = new BigInteger(1, this.buf);
        do {
            BigInteger k;
            int qBitLen = this.q.bitLength();
            while ((k = new BigInteger(qBitLen, this.random)).compareTo(this.q) != -1) {
            }
            r = this.g.modPow(k, this.p).mod(this.q);
            s = k.modInverse(this.q).multiply(data.add(this.x.multiply(r))).mod(this.q);
        } while (r.equals(this.ZERO) || s.equals(this.ZERO));
        return new SignatureData(r, s).getData();
    }

    protected void engineUpdate(byte b) throws SignatureException {
        if (this.bufPtr >= 20) {
            throw new SignatureException("Signature data length exceeded");
        }
        this.buf[this.bufPtr++] = b;
    }

    protected void engineUpdate(byte[] in, int offset, int length) throws SignatureException {
        if (this.bufPtr + length > 20) {
            throw new SignatureException("Signature data length exceeded");
        }
        System.arraycopy(in, offset, this.buf, this.bufPtr, length);
        this.bufPtr += length;
    }

    protected boolean engineVerify(byte[] signature) throws SignatureException {
        if (this.bufPtr != 20) {
            throw new SignatureException("Insufficient data for signature");
        }
        SignatureData sigData = new SignatureData(signature);
        BigInteger r = sigData.getR();
        BigInteger s = sigData.getS();
        if (r.compareTo(this.ZERO) != 1 || s.compareTo(this.ZERO) != 1 || r.compareTo(this.q) != -1 || s.compareTo(this.q) != -1) {
            throw new SignatureException("Invalid signature data");
        }
        BigInteger data = new BigInteger(1, this.buf);
        if (data.bitLength() > 160) {
            throw new InternalError("PANIC");
        }
        BigInteger w = s.modInverse(this.q);
        BigInteger u1 = data.multiply(w).mod(this.q);
        BigInteger u2 = r.multiply(w).mod(this.q);
        BigInteger gu1 = this.g.modPow(u1, this.p);
        BigInteger yu2 = this.y.modPow(u2, this.p);
        BigInteger v = gu1.multiply(yu2).mod(this.p).mod(this.q);
        if (w.compareTo(this.q) != -1) {
            throw new InternalError("PANIC");
        }
        if (v.compareTo(this.q) != -1) {
            throw new InternalError("PANIC");
        }
        if (u1.compareTo(this.q) != -1) {
            throw new InternalError("PANIC");
        }
        if (u2.compareTo(this.q) != -1) {
            throw new InternalError("PANIC");
        }
        if (gu1.compareTo(this.p) != -1) {
            throw new InternalError("PANIC");
        }
        if (yu2.compareTo(this.p) != -1) {
            throw new InternalError("PANIC");
        }
        return v.equals(r);
    }

    private boolean validate() {
        int pLen = this.p.bitLength();
        if (pLen > 1024 || pLen < 512 || pLen % 64 != 0) {
            return false;
        }
        if (this.q.bitLength() != 160 || this.g.compareTo(this.p) != -1) {
            return false;
        }
        if (this.y != null && this.y.compareTo(this.p) != -1) {
            return false;
        }
        if (this.x != null && this.x.compareTo(this.p) != -1) {
            return false;
        }
        if (this.x != null && this.y != null) {
            throw new InternalError("PANIC");
        }
        if (this.x == null && this.y == null) {
            throw new InternalError("PANIC");
        }
        return true;
    }
}

