/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.util.Collection;
import javax.resource.spi.work.WorkListener;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.MuleContextAware;
import org.mule.api.context.WorkManager;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleManager;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.Registry;
import org.mule.api.security.SecurityManager;
import org.mule.api.transaction.TransactionManagerFactory;
import org.mule.client.DefaultLocalMuleClient;
import org.mule.config.i18n.CoreMessages;
import org.mule.context.notification.MuleContextNotification;
import org.mule.context.notification.NotificationException;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.exception.DefaultSystemExceptionStrategy;
import org.mule.expression.DefaultExpressionManager;
import org.mule.lifecycle.MuleContextLifecycleManager;
import org.mule.management.stats.AllStatistics;
import org.mule.registry.DefaultRegistryBroker;
import org.mule.registry.MuleRegistryHelper;
import org.mule.util.ApplicationShutdownSplashScreen;
import org.mule.util.ApplicationStartupSplashScreen;
import org.mule.util.ServerShutdownSplashScreen;
import org.mule.util.ServerStartupSplashScreen;
import org.mule.util.SplashScreen;
import org.mule.util.queue.QueueManager;

public class DefaultMuleContext
implements MuleContext {
    private transient Log logger = LogFactory.getLog(DefaultMuleContext.class);
    private DefaultRegistryBroker registryBroker;
    private MuleRegistry muleRegistryHelper;
    private AllStatistics stats = new AllStatistics();
    private WorkManager workManager;
    private WorkListener workListener;
    protected MuleContextLifecycleManager lifecycleManager;
    protected ServerNotificationManager notificationManager;
    private MuleConfiguration config;
    private long startDate;
    private ExpressionManager expressionManager;
    private ClassLoader executionClassLoader;
    protected LocalMuleClient localMuleClient;
    protected SystemExceptionHandler exceptionListener;

    public DefaultMuleContext(MuleConfiguration config, WorkManager workManager, WorkListener workListener, MuleContextLifecycleManager lifecycleManager, ServerNotificationManager notificationManager) {
        this.config = config;
        ((MuleContextAware)((Object)config)).setMuleContext(this);
        this.workManager = workManager;
        this.workListener = workListener;
        this.lifecycleManager = lifecycleManager;
        this.notificationManager = notificationManager;
        this.notificationManager.setMuleContext(this);
        this.expressionManager = new DefaultExpressionManager();
        this.registryBroker = this.createRegistryBroker();
        this.muleRegistryHelper = this.createRegistryHelper(this.registryBroker);
        this.localMuleClient = new DefaultLocalMuleClient(this);
        this.exceptionListener = new DefaultSystemExceptionStrategy(this);
    }

    protected DefaultRegistryBroker createRegistryBroker() {
        return new DefaultRegistryBroker(this);
    }

    protected MuleRegistry createRegistryHelper(DefaultRegistryBroker registry) {
        return new MuleRegistryHelper(registry, this);
    }

    public synchronized void initialise() throws InitialisationException {
        this.lifecycleManager.checkPhase("initialise");
        if (this.getNotificationManager() == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("_muleNotificationManager"));
        }
        if (this.workManager == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("workManager"));
        }
        try {
            this.muleRegistryHelper.initialise();
            if (this.workManager instanceof MuleContextAware) {
                MuleContextAware contextAware = (MuleContextAware)((Object)this.workManager);
                contextAware.setMuleContext(this);
            }
            this.workManager.start();
            this.getNotificationManager().start(this.workManager, this.workListener);
            this.fireNotification(new MuleContextNotification((MuleContext)this, 101));
            this.getLifecycleManager().fireLifecycle("initialise");
            this.fireNotification(new MuleContextNotification((MuleContext)this, 102));
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public synchronized void start() throws MuleException {
        this.getLifecycleManager().checkPhase("start");
        if (this.getSecurityManager() == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("securityManager"));
        }
        if (this.getQueueManager() == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("queueManager"));
        }
        this.startDate = System.currentTimeMillis();
        this.fireNotification(new MuleContextNotification((MuleContext)this, 103));
        this.getLifecycleManager().fireLifecycle("start");
        this.fireNotification(new MuleContextNotification((MuleContext)this, 104));
        if (this.logger.isInfoEnabled()) {
            SplashScreen startupScreen = this.buildStartupSplash();
            this.logger.info((Object)startupScreen.toString());
        }
    }

    public synchronized void stop() throws MuleException {
        this.getLifecycleManager().checkPhase("stop");
        this.fireNotification(new MuleContextNotification((MuleContext)this, 105));
        this.getLifecycleManager().fireLifecycle("stop");
        this.fireNotification(new MuleContextNotification((MuleContext)this, 106));
    }

    public synchronized void dispose() {
        if (this.isStarted()) {
            try {
                this.stop();
            }
            catch (MuleException e) {
                this.logger.error((Object)"Failed to stop Mule context", (Throwable)e);
            }
        }
        this.getLifecycleManager().checkPhase("dispose");
        this.fireNotification(new MuleContextNotification((MuleContext)this, 107));
        try {
            this.getLifecycleManager().fireLifecycle("dispose");
            this.muleRegistryHelper.dispose();
        }
        catch (Exception e) {
            this.logger.debug((Object)("Failed to cleanly dispose Mule: " + e.getMessage()), (Throwable)e);
        }
        this.notificationManager.fireNotification(new MuleContextNotification((MuleContext)this, 108));
        this.notificationManager.dispose();
        this.workManager.dispose();
        if (this.getStartDate() > 0L && this.logger.isInfoEnabled()) {
            SplashScreen shutdownScreen = this.buildShutdownSplash();
            this.logger.info((Object)shutdownScreen.toString());
        }
    }

    public boolean isInitialised() {
        return this.getLifecycleManager().getState().isInitialised();
    }

    public boolean isInitialising() {
        return this.getLifecycleManager().getState().isInitialising();
    }

    public boolean isStopped() {
        return this.getLifecycleManager().getState().isStopped();
    }

    public boolean isStopping() {
        return this.getLifecycleManager().getState().isStopping();
    }

    public boolean isStarted() {
        return this.getLifecycleManager().isPhaseComplete("start");
    }

    public boolean isStarting() {
        return this.getLifecycleManager().getState().isStarting();
    }

    public boolean isDisposed() {
        return this.getLifecycleManager().getState().isDisposed();
    }

    public boolean isDisposing() {
        return this.getLifecycleManager().getState().isDisposing();
    }

    public LifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    public AllStatistics getStatistics() {
        return this.stats;
    }

    public void registerListener(ServerNotificationListener l) throws NotificationException {
        this.registerListener(l, null);
    }

    public void registerListener(ServerNotificationListener l, String resourceIdentifier) throws NotificationException {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager == null) {
            throw new MuleRuntimeException(CoreMessages.serverNotificationManagerNotEnabled());
        }
        notificationManager.addListenerSubscription(l, resourceIdentifier);
    }

    public void unregisterListener(ServerNotificationListener l) {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager != null) {
            notificationManager.removeListener(l);
        }
    }

    public void fireNotification(ServerNotification notification) {
        ServerNotificationManager notificationManager = this.getNotificationManager();
        if (notificationManager != null) {
            notificationManager.fireNotification(notification);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("MuleEvent Manager is not enabled, ignoring notification: " + notification));
        }
    }

    public void setSecurityManager(SecurityManager securityManager) throws RegistrationException {
        this.checkLifecycleForPropertySet("_muleSecurityManager", "initialise");
        this.registryBroker.registerObject("_muleSecurityManager", securityManager);
    }

    public SecurityManager getSecurityManager() {
        Collection<SecurityManager> temp;
        SecurityManager securityManager = (SecurityManager)this.registryBroker.lookupObject("_muleSecurityManager");
        if (securityManager == null && (temp = this.registryBroker.lookupObjects(SecurityManager.class)).size() > 0) {
            securityManager = temp.iterator().next();
        }
        return securityManager;
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public WorkListener getWorkListener() {
        return this.workListener;
    }

    public QueueManager getQueueManager() {
        Collection<QueueManager> temp;
        QueueManager queueManager = (QueueManager)this.registryBroker.lookupObject("_muleQueueManager");
        if (queueManager == null && (temp = this.registryBroker.lookupObjects(QueueManager.class)).size() > 0) {
            queueManager = temp.iterator().next();
        }
        return queueManager;
    }

    public void setQueueManager(QueueManager queueManager) throws RegistrationException {
        this.checkLifecycleForPropertySet("_muleQueueManager", "initialise");
        this.registryBroker.registerObject("_muleQueueManager", queueManager);
    }

    public MuleConfiguration getConfiguration() {
        return this.config;
    }

    public ServerNotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public void setTransactionManager(TransactionManager manager) throws RegistrationException {
        this.registryBroker.registerObject("_muleTransactionManager", manager);
    }

    public TransactionManager getTransactionManager() {
        TransactionManager transactionManager = (TransactionManager)this.registryBroker.lookupObject("_muleTransactionManager");
        if (transactionManager == null) {
            Collection<TransactionManagerFactory> temp = this.registryBroker.lookupObjects(TransactionManagerFactory.class);
            if (temp.size() > 0) {
                try {
                    transactionManager = temp.iterator().next().create(this.config);
                }
                catch (Exception e) {
                    throw new MuleRuntimeException(CoreMessages.failedToCreate("transaction manager"), (Throwable)e);
                }
            } else {
                temp = this.registryBroker.lookupObjects(TransactionManager.class);
                if (temp.size() > 0) {
                    transactionManager = (TransactionManager)temp.iterator().next();
                }
            }
        }
        return transactionManager;
    }

    protected void checkLifecycleForPropertySet(String propertyName, String phase) throws IllegalStateException {
        if (this.lifecycleManager.isPhaseComplete(phase)) {
            throw new IllegalStateException("Cannot set property: '" + propertyName + "' once the server has been gone through the " + phase + " phase.");
        }
    }

    public MuleRegistry getRegistry() {
        return this.muleRegistryHelper;
    }

    public ThreadingProfile getDefaultMessageDispatcherThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultMessageDispatcherThreadingProfile");
    }

    public ThreadingProfile getDefaultMessageRequesterThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultMessageRequesterThreadingProfile");
    }

    public ThreadingProfile getDefaultMessageReceiverThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultMessageReceiverThreadingProfile");
    }

    public ThreadingProfile getDefaultServiceThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultServiceThreadingProfile");
    }

    public ThreadingProfile getDefaultThreadingProfile() {
        return (ThreadingProfile)this.getRegistry().lookupObject("_defaultThreadingProfile");
    }

    public long getStartDate() {
        return this.startDate;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public void setExecutionClassLoader(ClassLoader cl) {
        this.executionClassLoader = cl;
    }

    public ClassLoader getExecutionClassLoader() {
        return this.executionClassLoader;
    }

    public void addRegistry(Registry registry) {
        this.registryBroker.addRegistry(registry);
    }

    public void removeRegistry(Registry registry) {
        this.registryBroker.removeRegistry(registry);
    }

    protected SplashScreen buildStartupSplash() {
        SplashScreen startupScreen = this.config.isContainerMode() ? new ApplicationStartupSplashScreen() : new ServerStartupSplashScreen();
        startupScreen.setHeader(this);
        startupScreen.setFooter(this);
        return startupScreen;
    }

    protected SplashScreen buildShutdownSplash() {
        SplashScreen shutdownScreen = this.config.isContainerMode() ? new ApplicationShutdownSplashScreen() : new ServerShutdownSplashScreen();
        shutdownScreen.setHeader(this);
        return shutdownScreen;
    }

    public LocalMuleClient getClient() {
        return this.localMuleClient;
    }

    public SystemExceptionHandler getExceptionListener() {
        return this.exceptionListener;
    }

    public void setExceptionListener(SystemExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
    }
}

