/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.component.LifecycleAdapterFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.model.EntryPointResolver;
import org.mule.api.model.EntryPointResolverSet;
import org.mule.api.model.Model;
import org.mule.component.DefaultComponentLifecycleAdapterFactory;
import org.mule.exception.DefaultServiceExceptionStrategy;
import org.mule.lifecycle.EmptyLifecycleCallback;
import org.mule.model.ModelLifecycleManager;
import org.mule.model.resolvers.DefaultEntryPointResolverSet;
import org.mule.model.resolvers.LegacyEntryPointResolverSet;
import org.mule.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModel
implements Model {
    public static final String DEFAULT_MODEL_NAME = "main";
    private String name = "main";
    private EntryPointResolverSet entryPointResolverSet = null;
    private LifecycleAdapterFactory lifecycleAdapterFactory = new DefaultComponentLifecycleAdapterFactory();
    private MessagingExceptionHandler exceptionListener = new DefaultServiceExceptionStrategy();
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected MuleContext muleContext;
    protected ModelLifecycleManager lifecycleManager = new ModelLifecycleManager(this);

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public LifecycleState getLifecycleState() {
        return this.lifecycleManager.getState();
    }

    @Override
    public EntryPointResolverSet getEntryPointResolverSet() {
        if (null == this.entryPointResolverSet) {
            this.entryPointResolverSet = new LegacyEntryPointResolverSet();
        }
        return this.entryPointResolverSet;
    }

    @Override
    public void setEntryPointResolverSet(EntryPointResolverSet entryPointResolverSet) {
        this.entryPointResolverSet = entryPointResolverSet;
    }

    public void setEntryPointResolvers(Collection<EntryPointResolver> entryPointResolvers) {
        if (null == this.entryPointResolverSet) {
            this.entryPointResolverSet = new DefaultEntryPointResolverSet();
        }
        for (EntryPointResolver resolver : entryPointResolvers) {
            this.entryPointResolverSet.addEntryPointResolver(resolver);
        }
    }

    @Override
    public LifecycleAdapterFactory getLifecycleAdapterFactory() {
        return this.lifecycleAdapterFactory;
    }

    @Override
    public void setLifecycleAdapterFactory(LifecycleAdapterFactory lifecycleAdapterFactory) {
        this.lifecycleAdapterFactory = lifecycleAdapterFactory;
    }

    @Override
    public void dispose() {
        if (this.getLifecycleState().isStarted()) {
            try {
                this.stop();
            }
            catch (MuleException e) {
                this.logger.error((Object)("Failed to stop model cleanly as part of a dispoae call: " + this.getName()), (Throwable)e);
            }
        }
        try {
            this.lifecycleManager.fireDisposePhase((LifecycleCallback<AbstractModel>)new EmptyLifecycleCallback<AbstractModel>());
        }
        catch (MuleException e) {
            this.logger.error((Object)("Failed to dispose model: " + this.getName()), (Throwable)e);
        }
    }

    @Override
    public void stop() throws MuleException {
        this.lifecycleManager.fireStopPhase((LifecycleCallback<AbstractModel>)new EmptyLifecycleCallback<AbstractModel>());
    }

    @Override
    public void start() throws MuleException {
        this.lifecycleManager.fireStartPhase((LifecycleCallback<AbstractModel>)new EmptyLifecycleCallback<AbstractModel>());
    }

    @Override
    public void initialise() throws InitialisationException {
        try {
            this.lifecycleManager.fireInitialisePhase((LifecycleCallback<AbstractModel>)new EmptyLifecycleCallback<AbstractModel>());
        }
        catch (InitialisationException e) {
            throw e;
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    public MessagingExceptionHandler getExceptionListener() {
        return this.exceptionListener;
    }

    @Override
    public void setExceptionListener(MessagingExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        if (this.exceptionListener instanceof MuleContextAware) {
            ((MuleContextAware)((Object)this.exceptionListener)).setMuleContext(this.muleContext);
        }
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public String toString() {
        return String.format("%s{%s}", ClassUtils.getSimpleName(this.getClass()), this.getName());
    }
}

