/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;
import org.mule.api.routing.filter.ObjectFilter;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;

public class WildcardFilter
implements Filter,
ObjectFilter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected volatile String pattern;
    protected volatile String[] patterns;
    private volatile boolean caseSensitive = true;

    public WildcardFilter() {
    }

    public WildcardFilter(String pattern) {
        this.setPattern(pattern);
    }

    public boolean accept(MuleMessage message) {
        try {
            return this.accept(message.getPayloadAsString());
        }
        catch (Exception e) {
            this.logger.warn((Object)"An exception occured while filtering", (Throwable)e);
            return false;
        }
    }

    public boolean accept(Object object) {
        if (object == null || this.pattern == null) {
            return false;
        }
        if (this.pattern.equals(object)) {
            return true;
        }
        String[] currentPatterns = this.patterns;
        if (currentPatterns != null) {
            for (String pattern : currentPatterns) {
                int i2;
                int i;
                boolean foundMatch;
                if ("*".equals(pattern) || "**".equals(pattern)) {
                    return true;
                }
                String candidate = object.toString();
                if (!this.isCaseSensitive()) {
                    pattern = pattern.toLowerCase();
                    candidate = candidate.toLowerCase();
                }
                if (!(foundMatch = (i = pattern.indexOf(42)) == -1 ? pattern.equals(candidate) : ((i2 = pattern.indexOf(42, i + 1)) > 1 ? candidate.indexOf(pattern.substring(1, i2)) > -1 : (i == 0 ? candidate.endsWith(pattern.substring(1)) : candidate.startsWith(pattern.substring(0, i)))))) continue;
                return true;
            }
        }
        return false;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.patterns = StringUtils.splitAndTrim(pattern, ",");
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WildcardFilter other = (WildcardFilter)obj;
        return ClassUtils.equal(this.pattern, other.pattern) && ClassUtils.equal(this.patterns, other.patterns) && this.caseSensitive == other.caseSensitive;
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.getClass(), this.pattern, this.patterns, this.caseSensitive});
    }
}

