/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import org.mule.DefaultMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageRouter;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.api.routing.RoutePathNotFoundException;
import org.mule.api.routing.RoutingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.transport.NullPayload;

public class ChainingRouter
extends FilteringOutboundRouter
implements MessageRouter {
    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.routes == null || this.routes.size() == 0) {
            throw new InitialisationException(CoreMessages.objectIsNull("targets"), (Initialisable)this);
        }
    }

    public MuleEvent route(MuleEvent event) throws RoutingException {
        MuleMessage message = event.getMessage();
        MuleEvent resultToReturn = null;
        if (this.routes == null || this.routes.size() == 0) {
            throw new RoutePathNotFoundException(CoreMessages.noEndpointsForRouter(), event, null);
        }
        int endpointsCount = this.routes.size();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("About to chain " + endpointsCount + " targets."));
        }
        MessageProcessor endpoint = null;
        try {
            MuleMessage intermediaryResult = message;
            for (int i = 0; i < endpointsCount; ++i) {
                boolean lastEndpointInChain;
                endpoint = this.getRoute(i, intermediaryResult);
                boolean bl = lastEndpointInChain = i == endpointsCount - 1;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Sending Chained message '" + i + "': " + (intermediaryResult == null ? "null" : intermediaryResult.toString())));
                }
                if (!lastEndpointInChain) {
                    MuleMessage localResult;
                    MuleEvent event1 = this.sendRequest(event, intermediaryResult, endpoint, true);
                    MuleMessage muleMessage = localResult = event1 == null ? null : event1.getMessage();
                    if (localResult != null && localResult.getPayload() != NullPayload.getInstance() && intermediaryResult != null) {
                        this.processIntermediaryResult(localResult, intermediaryResult);
                    }
                    intermediaryResult = localResult;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Received Chain result '" + i + "': " + (intermediaryResult != null ? intermediaryResult.toString() : "null")));
                    }
                    if (intermediaryResult != null && intermediaryResult.getPayload() != NullPayload.getInstance()) continue;
                    resultToReturn = intermediaryResult == null ? null : new DefaultMuleEvent(intermediaryResult, event);
                    this.logger.warn((Object)("Chaining router cannot process any further targets. There was no result returned from endpoint invocation: " + endpoint));
                    break;
                }
                resultToReturn = this.sendRequest(event, intermediaryResult, endpoint, true);
                if (!this.logger.isDebugEnabled()) continue;
                MuleMessage resultMessage = resultToReturn == null ? null : resultToReturn.getMessage();
                this.logger.debug((Object)("Received final Chain result '" + i + "': " + (resultMessage == null ? "null" : resultMessage.toString())));
            }
        }
        catch (MuleException e) {
            throw new CouldNotRouteOutboundMessageException(event, endpoint, (Throwable)e);
        }
        return resultToReturn;
    }

    protected void processIntermediaryResult(MuleMessage localResult, MuleMessage intermediaryResult) {
        localResult.setCorrelationId(intermediaryResult.getCorrelationId());
        localResult.setCorrelationSequence(intermediaryResult.getCorrelationSequence());
        localResult.setCorrelationGroupSize(intermediaryResult.getCorrelationGroupSize());
        localResult.setReplyTo(intermediaryResult.getReplyTo());
    }
}

