/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.service;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.registry.ServiceException;
import org.mule.api.registry.ServiceType;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.transport.AbstractConnector;
import org.mule.transport.service.TransportFactoryException;
import org.mule.transport.service.TransportServiceDescriptor;
import org.mule.util.BeanUtils;
import org.mule.util.ObjectNameHelper;

public class TransportFactory {
    protected static final Log logger = LogFactory.getLog(TransportFactory.class);
    protected MuleContext muleContext;

    public TransportFactory(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public Connector createConnector(EndpointURI url) throws TransportFactoryException {
        try {
            String scheme = url.getFullScheme();
            TransportServiceDescriptor sd = (TransportServiceDescriptor)this.muleContext.getRegistry().lookupServiceDescriptor(ServiceType.TRANSPORT, scheme, null);
            if (sd == null) {
                throw new ServiceException(CoreMessages.noServiceTransportDescriptor(scheme));
            }
            Connector connector = sd.createConnector();
            if (connector != null) {
                if (connector instanceof AbstractConnector) {
                    ((AbstractConnector)connector).initialiseFromUrl(url);
                }
            } else {
                throw new TransportFactoryException(CoreMessages.objectNotSetInService("Connector", scheme));
            }
            connector.setName(new ObjectNameHelper(this.muleContext).getConnectorName(connector));
            return connector;
        }
        catch (Exception e) {
            throw new TransportFactoryException(CoreMessages.failedToCreateObjectWith("Endpoint", url), (Throwable)e);
        }
    }

    public Connector createConnector(String uri) throws TransportFactoryException {
        try {
            return this.createConnector(new MuleEndpointURI(uri, this.muleContext));
        }
        catch (EndpointException e) {
            throw new TransportFactoryException(e);
        }
    }

    public Connector getOrCreateConnectorByProtocol(ImmutableEndpoint endpoint) throws TransportFactoryException {
        return this.getOrCreateConnectorByProtocol(endpoint.getEndpointURI());
    }

    public Connector getOrCreateConnectorByProtocol(EndpointURI uri) throws TransportFactoryException {
        Connector connector;
        String connectorName = uri.getConnectorName();
        if (null != connectorName && (connector = this.muleContext.getRegistry().lookupConnector(connectorName)) != null) {
            return connector;
        }
        connector = this.getConnectorByProtocol(uri.getFullScheme());
        if (connector == null) {
            connector = this.createConnector(uri);
            try {
                BeanUtils.populate(connector, uri.getParams());
                this.muleContext.getRegistry().registerConnector(connector);
            }
            catch (Exception e) {
                throw new TransportFactoryException(e);
            }
        }
        return connector;
    }

    public Connector getConnectorByProtocol(String protocol) {
        ArrayList<Connector> results = new ArrayList<Connector>();
        Collection<Connector> connectors = this.muleContext.getRegistry().lookupObjects(Connector.class);
        for (Connector connector : connectors) {
            if (!connector.supportsProtocol(protocol)) continue;
            results.add(connector);
        }
        if (results.size() > 1) {
            StringBuffer buf = new StringBuffer();
            for (Connector result : results) {
                buf.append(result.getName()).append(", ");
            }
            throw new IllegalStateException(CoreMessages.moreThanOneConnectorWithProtocol(protocol, buf.toString()).getMessage());
        }
        if (results.size() == 1) {
            return (Connector)results.get(0);
        }
        return null;
    }
}

