/*
 * Decompiled with CFR 0.152.
 */
package mx4j.remote;

import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.remote.JMXServiceURL;
import mx4j.log.Logger;
import mx4j.remote.ProviderHelper;

public abstract class ConnectionResolver
extends ProviderHelper {
    public static ConnectionResolver newConnectionResolver(String proto, Map environment) {
        String protocol = ConnectionResolver.normalizeProtocol(proto);
        String resolverPackages = ConnectionResolver.findResolverPackageList();
        ClassLoader classLoader = ConnectionResolver.findResolverClassLoader(environment, "jmx.remote.protocol.provider.class.loader");
        return ConnectionResolver.loadResolver(resolverPackages, protocol, classLoader);
    }

    private static String findResolverPackageList() {
        String packages = ConnectionResolver.findSystemPackageList("mx4j.remote.resolver.pkgs");
        packages = packages == null ? "mx4j.remote.resolver|mx4j.tools.remote.resolver" : packages + "|mx4j.remote.resolver|mx4j.tools.remote.resolver";
        Logger logger = ConnectionResolver.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug("Resolver packages list is: " + packages);
        }
        return packages;
    }

    private static ClassLoader findResolverClassLoader(Map environment, String loaderKey) {
        if (environment == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        Object object = environment.get(loaderKey);
        if (object == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        if (!(object instanceof ClassLoader)) {
            throw new IllegalArgumentException("Environment property " + loaderKey + " must be a ClassLoader");
        }
        return (ClassLoader)object;
    }

    private static ConnectionResolver loadResolver(String packages, String protocol, ClassLoader loader) {
        Logger logger = ConnectionResolver.getLogger();
        StringTokenizer tokenizer = new StringTokenizer(packages, "|");
        while (tokenizer.hasMoreTokens()) {
            String pkg = tokenizer.nextToken().trim();
            if (logger.isEnabledFor(10)) {
                logger.debug("Resolver package: " + pkg);
            }
            if (pkg.length() == 0) continue;
            String className = protocol.toUpperCase() + "Resolver";
            String resolverClassName = ConnectionResolver.constructClassName(pkg, protocol, className);
            Class resolverClass = null;
            try {
                resolverClass = ConnectionResolver.loadClass(resolverClassName, loader);
            }
            catch (ClassNotFoundException x) {
                if (!logger.isEnabledFor(10)) continue;
                logger.debug("Resolver class " + resolverClassName + " not found, continuing with next package");
                continue;
            }
            catch (Exception x) {
                if (logger.isEnabledFor(0)) {
                    logger.trace("Cannot load resolver class " + resolverClassName, x);
                }
                return null;
            }
            try {
                return (ConnectionResolver)resolverClass.newInstance();
            }
            catch (Exception x) {
                if (logger.isEnabledFor(0)) {
                    logger.trace("Cannot instantiate resolver class " + resolverClassName, x);
                }
                return null;
            }
        }
        if (logger.isEnabledFor(10)) {
            logger.debug("Could not find resolver for protocol " + protocol + " in package list '" + packages + "'");
        }
        return null;
    }

    public abstract Object lookupClient(JMXServiceURL var1, Map var2) throws IOException;

    public abstract Object bindClient(Object var1, Map var2) throws IOException;

    public abstract Object createServer(JMXServiceURL var1, Map var2) throws IOException;

    public abstract JMXServiceURL bindServer(Object var1, JMXServiceURL var2, Map var3) throws IOException;

    public abstract void unbindServer(Object var1, JMXServiceURL var2, Map var3) throws IOException;

    public abstract void destroyServer(Object var1, JMXServiceURL var2, Map var3) throws IOException;
}

