/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.rss.endpoint;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.config.i18n.CoreMessages;
import org.mule.endpoint.DefaultInboundEndpoint;
import org.mule.module.rss.transformers.ObjectToRssFeed;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RssInboundEndpoint
extends DefaultInboundEndpoint {
    private boolean splitFeed;
    private Date lastUpdate;
    private List<String> acceptedMimeTypes;
    private ObjectToRssFeed inTransform = new ObjectToRssFeed();
    private Set<String> supportedProtocols = new HashSet<String>(2);

    public RssInboundEndpoint(boolean splitFeed, Date lastUpdate, List<String> acceptedContentTypes, InboundEndpoint ie) {
        super(ie.getConnector(), ie.getEndpointURI(), ie.getName(), ie.getProperties(), ie.getTransactionConfig(), ie.isDeleteUnacceptedMessages(), ie.getExchangePattern(), ie.getResponseTimeout(), ie.getInitialState(), ie.getEncoding(), ie.getEndpointBuilderName(), ie.getMuleContext(), ie.getRetryPolicyTemplate(), ie.getMessageProcessorsFactory(), ie.getMessageProcessors(), ie.getResponseMessageProcessors(), ie.isDisableTransportTransformer(), ie.getMimeType());
        this.splitFeed = splitFeed;
        this.lastUpdate = lastUpdate;
        this.acceptedMimeTypes = acceptedContentTypes;
    }

    public boolean isSplitFeed() {
        return this.splitFeed;
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public List<String> getAcceptedMimeTypes() {
        return this.acceptedMimeTypes;
    }

    void registerSupportedProtocol(String protocol) {
        this.supportedProtocols.add(protocol);
    }

    boolean unregisterProtocol(String protocol) {
        return this.supportedProtocols.remove(protocol);
    }

    @Override
    public boolean isProtocolSupported(String protocol) {
        return this.supportedProtocols.contains(protocol);
    }

    public boolean onMessage(MuleMessage message) throws MuleException {
        String mimeType = this.getMime(message);
        if (this.getProtocol().startsWith("http") && !this.isMimeSupported(mimeType)) {
            if (mimeType == null) {
                throw new MessagingException(CoreMessages.createStaticMessage("Mime type not set on message, cannot validate that message is an AtomInboundEndpointFactoryBean feed"), message);
            }
            throw new MessagingException(CoreMessages.createStaticMessage("Mime type not supported '" + mimeType + "', supported types are: " + this.getAcceptedMimeTypes()), message);
        }
        if (mimeType == null) {
            logger.warn((Object)("Mime type not set on message, but connector protocol '" + this.getProtocol() + "' does not explicitly support mimeTypes. Message type will not be validated"));
        }
        message.applyTransformers((MuleEvent)null, this.inTransform);
        return true;
    }

    public boolean isMimeSupported(String mime) {
        return this.acceptedMimeTypes.contains(mime);
    }

    private String getMime(MuleMessage m) {
        if (m == null) {
            return null;
        }
        String mimeType = (String)m.getOutboundProperty("Content-Type");
        int i = mimeType.indexOf(";");
        if (i > -1) {
            mimeType = mimeType.substring(0, i);
        }
        return mimeType;
    }
}

