/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.rss.routing;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transport.PropertyScope;
import org.mule.module.rss.transformers.ObjectToRssFeed;
import org.mule.processor.AbstractFilteringMessageProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InboundFeedSplitter
extends AbstractFilteringMessageProcessor {
    protected final transient Log logger = LogFactory.getLog(InboundFeedSplitter.class);
    public static final String FEED_PROPERTY = "feed.object";
    private Filter entryFilter;
    private List<String> acceptedContentTypes;
    private ObjectToRssFeed objectToFeed = new ObjectToRssFeed();

    public InboundFeedSplitter() {
        this.acceptedContentTypes = new ArrayList<String>();
        this.acceptedContentTypes.add("application/rss+xml");
        this.acceptedContentTypes.add("application/rss");
    }

    @Override
    public MuleEvent process(MuleEvent muleEvent) throws MessagingException {
        try {
            Object payload = muleEvent.getMessage().getPayload();
            SyndFeed feed = payload instanceof SyndFeed ? (SyndFeed)payload : (SyndFeed)this.objectToFeed.transform(muleEvent.getMessage().getPayload());
            TreeSet<SyndEntry> entries = new TreeSet<SyndEntry>(new EntryComparator());
            entries.addAll(feed.getEntries());
            ArrayList<DefaultMuleEvent> events = new ArrayList<DefaultMuleEvent>();
            for (SyndEntry syndEntry : entries) {
                DefaultMuleMessage m = new DefaultMuleMessage(syndEntry, muleEvent.getMuleContext());
                if (this.entryFilter != null && !this.entryFilter.accept(m)) continue;
                m.setProperty(FEED_PROPERTY, feed, PropertyScope.INVOCATION);
                DefaultMuleEvent e = new DefaultMuleEvent((MuleMessage)m, muleEvent.getEndpoint(), muleEvent.getFlowConstruct(), muleEvent);
                events.add(e);
            }
            for (MuleEvent muleEvent2 : events) {
                this.processNext(muleEvent2);
            }
        }
        catch (MuleException e) {
            throw new MessagingException(e.getI18nMessage(), muleEvent, (Throwable)e);
        }
        return null;
    }

    @Override
    public boolean accept(MuleEvent muleEvent) {
        String contentType = (String)muleEvent.getMessage().getOutboundProperty("Content-Type");
        if (contentType != null) {
            int i = contentType.indexOf(";");
            contentType = i > -1 ? contentType.substring(0, i) : contentType;
            return this.acceptedContentTypes.contains(contentType);
        }
        this.logger.warn((Object)"Content-Type header not set, not accepting the message");
        return false;
    }

    public Filter getEntryFilter() {
        return this.entryFilter;
    }

    public void setEntryFilter(Filter entryFilter) {
        this.entryFilter = entryFilter;
    }

    public List<String> getAcceptedContentTypes() {
        return this.acceptedContentTypes;
    }

    public void setAcceptedContentTypes(List<String> acceptedContentTypes) {
        this.acceptedContentTypes = acceptedContentTypes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntryComparator
    implements Comparator<SyndEntry> {
        EntryComparator() {
        }

        @Override
        public int compare(SyndEntry e1, SyndEntry e2) {
            if (e1.getPublishedDate().before(e2.getPublishedDate())) {
                return -1;
            }
            if (e1.equals(e2)) {
                return 0;
            }
            return 1;
        }
    }
}

