/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.config.ExceptionReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLExceptionReader
implements ExceptionReader {
    public String getMessage(Throwable t) {
        SQLException e = (SQLException)t;
        return e.getMessage() + "(SQL Code: " + e.getErrorCode() + ", SQL State: + " + e.getSQLState() + ")";
    }

    public Throwable getCause(Throwable t) {
        SQLException e = (SQLException)t;
        Throwable cause = e.getNextException();
        if (cause == null) {
            cause = e.getCause();
        }
        return cause;
    }

    public Class<?> getExceptionType() {
        return SQLException.class;
    }

    public Map<?, ?> getInfo(Throwable t) {
        SQLException e = (SQLException)t;
        HashMap<String, String> info = new HashMap<String, String>();
        if (e.getErrorCode() != 0) {
            info.put("SQL Code", String.valueOf(e.getErrorCode()));
        }
        if (e.getSQLState() != null && !e.getSQLState().equals("")) {
            info.put("SQL State", e.getSQLState());
        }
        return info;
    }
}

