/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd.continuation;

import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletContext;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.ClientImpl;
import org.mortbay.cometd.continuation.ContinuationClient;
import org.mortbay.thread.Timeout;

public class ContinuationBayeux
extends AbstractBayeux {
    private static int __id;
    private transient Timer _tick;
    private transient Timeout _timeout;
    private long _now;

    public ClientImpl newRemoteClient() {
        return new ContinuationClient(this);
    }

    protected void initialize(ServletContext context) {
        super.initialize(context);
        this._tick = new Timer("ContinuationBayeux-" + __id++, true);
        this._timeout = new Timeout();
        this._timeout.setDuration(this.getMaxInterval());
        this._tick.schedule(new TimerTask(){

            public void run() {
                ContinuationBayeux.this._now = System.currentTimeMillis();
                ContinuationBayeux.this._timeout.tick(ContinuationBayeux.this._now);
            }
        }, 100L, 100L);
    }

    long getNow() {
        return this._now;
    }

    public void setMaxInterval(long ms) {
        this._timeout.setDuration(ms);
        super.setMaxInterval(ms);
    }

    public void destroy() {
        this._tick.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startIntervalTimeout(Timeout.Task timeout, long interval) {
        Timeout timeout2 = this._timeout;
        synchronized (timeout2) {
            if (interval == 0L || interval == this._maxInterval) {
                this._timeout.schedule(timeout);
            } else {
                long delay = interval - this.getMaxInterval();
                this._timeout.schedule(timeout, delay);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelIntervalTimeout(Timeout.Task timeout) {
        Timeout timeout2 = this._timeout;
        synchronized (timeout2) {
            if (timeout != null) {
                timeout.cancel();
            }
        }
    }
}

