/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ibeans.config;

import org.ibeans.impl.IBeansNotationHelper;
import org.ibeans.impl.view.TextView;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.module.ibeans.config.IBeanBinding;
import org.mule.module.ibeans.config.IBeanFlowConstruct;
import org.mule.module.ibeans.spi.MuleIBeansPlugin;

public class IBeanHolder
implements Comparable {
    private Class ibean;
    private String usage;

    public IBeanHolder(Class ibean) {
        this.ibean = ibean;
    }

    public int compareTo(Object o) {
        IBeanHolder to = (IBeanHolder)o;
        return this.getId().compareTo(to.getId());
    }

    public Class getIbeanClass() {
        return this.ibean;
    }

    public Object create(MuleContext context, MuleIBeansPlugin plugin) throws MuleException {
        IBeanFlowConstruct flow = new IBeanFlowConstruct(this.ibean.getSimpleName() + "." + System.identityHashCode(this), context);
        context.getRegistry().registerObject(flow.getName(), (Object)flow, FlowConstruct.class);
        IBeanBinding router = new IBeanBinding(flow, plugin);
        router.setInterface(this.ibean);
        return router.createProxy(new Object());
    }

    public String getId() {
        return IBeansNotationHelper.getIBeanShortID((Class)this.ibean);
    }

    public String getUsage() {
        if (this.usage == null) {
            TextView view = new TextView();
            this.usage = view.createView(this.ibean);
        }
        return this.usage;
    }

    public String toString() {
        return "IBean: " + this.getId() + " : " + this.ibean.getName();
    }
}

