/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ibean;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Properties;
import org.ibeans.annotation.Call;
import org.ibeans.annotation.Template;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.endpoint.ResourceNameEndpointURIBuilder;
import org.mule.module.ibeans.config.IBeanHolder;
import org.mule.module.ibeans.i18n.IBeansMessages;

public class IBeansEndpointURIBuilder
extends ResourceNameEndpointURIBuilder {
    private MuleContext muleContext;

    protected void setEndpoint(URI uri, Properties props) throws MalformedEndpointException {
        super.setEndpoint(uri, props);
        int i = this.address.indexOf(".");
        if (i == -1) {
            throw new MalformedEndpointException(uri.toString());
        }
        String ibean = this.address.substring(0, i);
        String method = this.address.substring(i + 1);
        IBeanHolder holder = (IBeanHolder)this.muleContext.getRegistry().lookupObject(ibean);
        if (holder == null) {
            throw new MalformedEndpointException(IBeansMessages.ibeanNotRegistered(ibean), uri.toString());
        }
        boolean match = false;
        Method[] methods = holder.getIbeanClass().getMethods();
        for (int j = 0; j < methods.length; ++j) {
            Method m = methods[j];
            if (!m.getName().equals(method)) continue;
            if (m.isAnnotationPresent(Call.class) || m.isAnnotationPresent(Template.class)) {
                match = true;
                break;
            }
            throw new MalformedEndpointException(IBeansMessages.ibeanMethodFoundButNotValid(ibean, method), uri.toString());
        }
        if (!match) {
            throw new MalformedEndpointException(IBeansMessages.ibeanMethodNotFound(ibean, method), uri.toString());
        }
    }

    public EndpointURI build(URI uri, MuleContext muleContext) throws MalformedEndpointException {
        this.muleContext = muleContext;
        return super.build(uri, muleContext);
    }
}

