/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.module.launcher.Application;
import org.mule.module.launcher.ApplicationWrapper;
import org.mule.module.launcher.DefaultMuleApplication;
import org.mule.module.launcher.MuleDeployer;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.util.FileUtils;
import org.mule.util.FilenameUtils;

public class DefaultMuleDeployer
implements MuleDeployer {
    protected final transient Log logger = LogFactory.getLog(this.getClass());

    public void deploy(Application app) {
        try {
            app.install();
            app.init();
            app.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void undeploy(Application app) {
        try {
            app.stop();
            app.dispose();
            File appDir = new File(MuleContainerBootstrapUtils.getMuleAppsDir(), app.getAppName());
            FileUtils.deleteDirectory((File)appDir);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public Application installFromAppDir(String packedMuleAppFileName) throws IOException {
        File appsDir = MuleContainerBootstrapUtils.getMuleAppsDir();
        File appFile = new File(appsDir, packedMuleAppFileName);
        if (!appFile.getParentFile().equals(appsDir)) {
            throw new SecurityException("installFromAppDir() can only deploy from $MULE_HOME/apps. Use installFrom(url) instead.");
        }
        return this.installFrom(appFile.toURL());
    }

    public Application installFrom(URL url) throws IOException {
        String appName;
        if (!url.toString().endsWith(".zip")) {
            throw new IllegalArgumentException("Only Mule application zips are supported: " + url);
        }
        File appsDir = MuleContainerBootstrapUtils.getMuleAppsDir();
        try {
            String fullPath = url.toURI().toString();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Exploding a Mule application archive: " + fullPath));
            }
            appName = FilenameUtils.getBaseName((String)fullPath);
            File appDir = new File(appsDir, appName);
            File source = new File(url.toURI());
            FileUtils.unzip(source, appDir);
            if ("file".equals(url.getProtocol())) {
                FileUtils.deleteQuietly((File)source);
            }
        }
        catch (URISyntaxException e) {
            IOException ex = new IOException(e.getMessage());
            ex.fillInStackTrace();
            throw ex;
        }
        return new ApplicationWrapper(new DefaultMuleApplication(appName));
    }
}

