/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp;

import cryptix.openpgp.PGPAbstractSignatureParameterBuilder;
import cryptix.openpgp.signature.PGPBooleanSP;
import cryptix.openpgp.signature.PGPByteArraySP;
import cryptix.openpgp.signature.PGPDateSP;
import cryptix.openpgp.signature.PGPKeyFlagsSP;
import cryptix.openpgp.signature.PGPKeyServerPrefsSP;
import cryptix.openpgp.signature.PGPStringSP;
import cryptix.pki.KeyID;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Date;

public class PGPSelfCertificateParameterBuilder
extends PGPAbstractSignatureParameterBuilder {
    public PGPSelfCertificateParameterBuilder(KeyID issuerkeyid) {
        super(issuerkeyid, (byte)19);
        this.addDefaultPreferences();
    }

    public PGPSelfCertificateParameterBuilder(Key issuerkey) throws InvalidKeyException {
        super(issuerkey, (byte)19);
        this.addDefaultPreferences();
    }

    private void addDefaultPreferences() {
        byte[] ciph = new byte[]{7, 8, 9, 3, 2};
        byte[] hash = new byte[]{2, 3};
        byte[] byArray = new byte[3];
        byArray[0] = 2;
        byArray[1] = 1;
        byte[] comp = byArray;
        PGPByteArraySP ciphprefs = new PGPByteArraySP();
        ciphprefs.setValue(ciph);
        ciphprefs.setPacketID((byte)11);
        PGPByteArraySP hashprefs = new PGPByteArraySP();
        hashprefs.setValue(hash);
        hashprefs.setPacketID((byte)21);
        PGPByteArraySP compprefs = new PGPByteArraySP();
        compprefs.setValue(comp);
        compprefs.setPacketID((byte)22);
        this.addPacket(ciphprefs);
        this.addPacket(hashprefs);
        this.addPacket(compprefs);
    }

    public void setExpirationDate(Date expiration) {
        if (expiration == null) {
            this.removePacket((byte)3);
        } else {
            PGPDateSP pkt = new PGPDateSP();
            pkt.setValue(expiration);
            pkt.setPacketID((byte)3);
            this.setPacket(pkt);
        }
    }

    public void setKeyExpirationDate(Date expiration) {
        if (expiration == null) {
            this.removePacket((byte)9);
        } else {
            PGPDateSP pkt = new PGPDateSP();
            pkt.setValue(expiration);
            pkt.setPacketID((byte)9);
            this.setPacket(pkt);
        }
    }

    public void setKeyFlags(boolean certification, boolean signdata, boolean encryptcommunication, boolean encryptstorage) {
        if (certification && signdata && encryptcommunication && encryptstorage) {
            this.removePacket((byte)27);
        } else {
            PGPKeyFlagsSP pkt = new PGPKeyFlagsSP();
            pkt.setCertify(certification);
            pkt.setSign(signdata);
            pkt.setEncryptCommunication(encryptcommunication);
            pkt.setEncryptStorage(encryptstorage);
            pkt.setPacketID((byte)27);
            this.setPacket(pkt);
        }
    }

    public void setKeyServerPreferences(boolean nomodify) {
        if (!nomodify) {
            this.removePacket((byte)23);
        } else {
            PGPKeyServerPrefsSP pkt = new PGPKeyServerPrefsSP();
            pkt.setNoModify(nomodify);
            pkt.setPacketID((byte)23);
            this.setPacket(pkt);
        }
    }

    public void setPreferredCompressionAlgorithms(byte[] preferences) {
        if (preferences == null) {
            this.removePacket((byte)22);
        } else {
            PGPByteArraySP pkt = new PGPByteArraySP();
            pkt.setValue(preferences);
            pkt.setPacketID((byte)22);
            this.setPacket(pkt);
        }
    }

    public void setPreferredHashAlgorithms(byte[] preferences) {
        if (preferences == null) {
            this.removePacket((byte)21);
        } else {
            PGPByteArraySP pkt = new PGPByteArraySP();
            pkt.setValue(preferences);
            pkt.setPacketID((byte)21);
            this.setPacket(pkt);
        }
    }

    public void setPreferredKeyServer(String url) {
        if (url == null) {
            this.removePacket((byte)24);
        } else {
            PGPStringSP pkt = new PGPStringSP();
            pkt.setValue(url);
            pkt.setPacketID((byte)24);
            this.setPacket(pkt);
        }
    }

    public void setPreferredSymmetricAlgorithms(byte[] preferences) {
        if (preferences == null) {
            this.removePacket((byte)11);
        } else {
            PGPByteArraySP pkt = new PGPByteArraySP();
            pkt.setValue(preferences);
            pkt.setPacketID((byte)11);
            this.setPacket(pkt);
        }
    }

    public void setPrimaryUserID(boolean primaryuserid) {
        if (!primaryuserid) {
            this.removePacket((byte)25);
        } else {
            PGPBooleanSP pkt = new PGPBooleanSP();
            pkt.setValue(true);
            pkt.setPacketID((byte)25);
            this.setPacket(pkt);
        }
    }

    public void setRevocable(boolean revocable) {
        if (revocable) {
            this.removePacket((byte)7);
        } else {
            PGPBooleanSP pkt = new PGPBooleanSP();
            pkt.setValue(false);
            pkt.setPacketID((byte)7);
            this.setPacket(pkt);
        }
    }
}

