/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.packet;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.packet.PGPPacket;
import cryptix.openpgp.packet.PGPPacketFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public abstract class PGPContainerPacket
extends PGPPacket {
    private static final int BUFSIZE = 1024;
    private Vector packets = new Vector();

    public void appendPacket(PGPPacket p) {
        this.packets.addElement(p);
    }

    protected void decodeSubPackets(InputStream in, PGPAlgorithmFactory fac) throws PGPDataFormatException, PGPFatalDataFormatException, IOException {
        block10: {
            int len;
            ByteArrayOutputStream xfer = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                xfer.write(buf, 0, len);
            }
            ByteArrayInputStream packetData = null;
            try {
                packetData = new ByteArrayInputStream(xfer.toByteArray());
                xfer = null;
                while (packetData.available() > 0) {
                    this.appendPacket(PGPPacketFactory.getDefaultInstance().readPacket(packetData, fac));
                }
                packetData.close();
                Object var8_8 = null;
                if (packetData == null) break block10;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (packetData != null) {
                    try {
                        packetData.close();
                    }
                    catch (Exception exception) {}
                    packetData = null;
                }
                throw throwable;
            }
            try {
                packetData.close();
            }
            catch (Exception exception) {}
            packetData = null;
        }
    }

    protected void encodeSubPackets(OutputStream out) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Enumeration i = this.listPackets();
        while (i.hasMoreElements()) {
            ((PGPPacket)i.nextElement()).encode(buffer);
            buffer.flush();
            byte[] barr = buffer.toByteArray();
            out.write(barr);
            buffer.reset();
        }
    }

    public boolean equals(Object ssp) {
        if (ssp != null && ssp instanceof PGPContainerPacket) {
            PGPContainerPacket other = (PGPContainerPacket)ssp;
            Enumeration thisList = this.listPackets();
            Enumeration otherList = other.listPackets();
            while (thisList.hasMoreElements()) {
                if (!otherList.hasMoreElements()) {
                    return false;
                }
                if (thisList.nextElement().equals(otherList.nextElement())) continue;
                return false;
            }
            return otherList.hasMoreElements() ^ true;
        }
        return false;
    }

    public Enumeration listPackets() {
        return this.packets.elements();
    }
}

