/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Command;
import org.jbpm.api.cmd.Environment;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.Transition;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.task.TaskImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetOutcomes
implements Command<Set<String>> {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public GetOutcomes(String taskId) {
        if (taskId == null) {
            throw new JbpmException("taskId is null");
        }
        this.taskId = taskId;
    }

    public Set<String> execute(Environment environment) {
        List<Transition> outgoingTransitions;
        DbSession dbSession = (DbSession)environment.get(DbSession.class);
        TaskImpl task = dbSession.get(TaskImpl.class, Long.parseLong(this.taskId));
        if (task == null) {
            throw new JbpmException("task " + this.taskId + " doesn't exist");
        }
        HashSet<String> outcomes = new HashSet<String>();
        outcomes.add("completed");
        ExecutionImpl execution = task != null ? task.getExecution() : null;
        ActivityImpl activity = execution != null ? execution.getActivity() : null;
        List<Transition> list = outgoingTransitions = activity != null ? activity.getOutgoingTransitions() : null;
        if (outgoingTransitions != null) {
            for (Transition transition : outgoingTransitions) {
                outcomes.add(transition.getName());
            }
        }
        return outcomes;
    }
}

