/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.id;

import java.util.ArrayList;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.history.model.HistoryActivityInstanceImpl;
import org.jbpm.pvm.internal.history.model.HistoryDetailImpl;
import org.jbpm.pvm.internal.history.model.HistoryTaskImpl;
import org.jbpm.pvm.internal.history.model.HistoryVariableImpl;
import org.jbpm.pvm.internal.identity.impl.GroupImpl;
import org.jbpm.pvm.internal.identity.impl.MembershipImpl;
import org.jbpm.pvm.internal.identity.impl.UserImpl;
import org.jbpm.pvm.internal.job.JobImpl;
import org.jbpm.pvm.internal.lob.Lob;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.repository.DeploymentImpl;
import org.jbpm.pvm.internal.repository.DeploymentProperty;
import org.jbpm.pvm.internal.task.ParticipationImpl;
import org.jbpm.pvm.internal.task.SwimlaneImpl;
import org.jbpm.pvm.internal.task.TaskImpl;
import org.jbpm.pvm.internal.type.Variable;

public class PropertyImpl {
    private static Log log = Log.getLog((String)PropertyImpl.class.getName());
    public static final String DB_VERSION_KEY = "db.version";
    public static final String NEXT_DBID_KEY = "next.dbid";
    protected int version;
    protected String key;
    protected String value;

    protected PropertyImpl() {
    }

    public PropertyImpl(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public static Long getNextDbid(Session session) {
        String dbidPropertyValue = PropertyImpl.getPropertyValue(session, NEXT_DBID_KEY);
        if (dbidPropertyValue != null) {
            return Long.valueOf(dbidPropertyValue);
        }
        return null;
    }

    public static void setNextDbid(Session session, long nextDbid) {
        PropertyImpl.setPropertyValue(session, NEXT_DBID_KEY, Long.toString(nextDbid));
    }

    public static String getDbVersion(Session session) {
        String dbVersionPropertyValue = PropertyImpl.getPropertyValue(session, DB_VERSION_KEY);
        if (dbVersionPropertyValue != null) {
            return dbVersionPropertyValue;
        }
        return null;
    }

    public static void setDbVersionToLibraryVersion(Session session) {
        PropertyImpl.setPropertyValue(session, DB_VERSION_KEY, "4.2");
    }

    public static void createProperties(Session session) {
        PropertyImpl.setDbVersionToLibraryVersion(session);
        PropertyImpl.setNextDbid(session, 1L);
    }

    public static void upgradeProperties(Session session) {
        PropertyImpl.setDbVersionToLibraryVersion(session);
        long nextDbid = PropertyImpl.getMaxDbid(session) + 1L;
        PropertyImpl.setNextDbid(session, nextDbid);
        log.info("nextDbid is initialized to " + nextDbid);
    }

    public static boolean propertiesTableExists(Session session) {
        try {
            session.createQuery("from " + PropertyImpl.class.getName()).setMaxResults(1).uniqueResult();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected static long getMaxDbid(Session session) {
        long maxDbid = 0L;
        ArrayList<String> persistedTypes = new ArrayList<String>();
        persistedTypes.add(DeploymentImpl.class.getName());
        persistedTypes.add(DeploymentProperty.class.getName());
        persistedTypes.add(ExecutionImpl.class.getName());
        persistedTypes.add(GroupImpl.class.getName());
        persistedTypes.add(HistoryActivityInstanceImpl.class.getName());
        persistedTypes.add(HistoryDetailImpl.class.getName());
        persistedTypes.add(HistoryTaskImpl.class.getName());
        persistedTypes.add(HistoryVariableImpl.class.getName());
        persistedTypes.add(JobImpl.class.getName());
        persistedTypes.add(Lob.class.getName());
        persistedTypes.add(MembershipImpl.class.getName());
        persistedTypes.add(ParticipationImpl.class.getName());
        persistedTypes.add(SwimlaneImpl.class.getName());
        persistedTypes.add(TaskImpl.class.getName());
        persistedTypes.add(UserImpl.class.getName());
        persistedTypes.add(Variable.class.getName());
        for (String persistedType : persistedTypes) {
            try {
                Long typeMaxDbid = (Long)session.createQuery("select max(o.dbid) from " + persistedType + " as o").uniqueResult();
                if (typeMaxDbid == null || typeMaxDbid <= maxDbid) continue;
                maxDbid = typeMaxDbid;
            }
            catch (Exception e) {
                log.info("couldn't get max dbid for " + persistedType, (Throwable)e);
                e.printStackTrace();
            }
        }
        return maxDbid;
    }

    protected static String getPropertyValue(Session session, String propertyKey) {
        PropertyImpl dbidProperty = PropertyImpl.getProperty(session, propertyKey);
        if (dbidProperty == null) {
            return null;
        }
        return dbidProperty.getValue();
    }

    protected static void setPropertyValue(Session session, String propertyKey, String propertyValue) {
        PropertyImpl property = PropertyImpl.getProperty(session, propertyKey);
        if (property == null) {
            property = new PropertyImpl(propertyKey, propertyValue);
            session.save((Object)property);
        } else {
            property.setValue(propertyValue);
        }
    }

    protected static PropertyImpl getProperty(Session session, String key) {
        return (PropertyImpl)session.createCriteria(PropertyImpl.class).add((Criterion)Restrictions.eq((String)"key", (Object)key)).uniqueResult();
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

