/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model.op;

import org.jbpm.pvm.internal.job.MessageImpl;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.op.AtomicOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitionEndActivity
extends AtomicOperation {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isAsync(ExecutionImpl execution) {
        return false;
    }

    @Override
    public void perform(ExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        ExecutionImpl propagatingExecution = execution;
        if (activity.isLocalScope()) {
            propagatingExecution = execution.destroyScope(activity);
        }
        ActivityImpl parentActivity = activity.getParentActivity();
        ActivityImpl destination = execution.getTransition().getDestination();
        if (parentActivity != null && !parentActivity.contains(destination)) {
            propagatingExecution.setActivity(parentActivity);
            propagatingExecution.fire("end", parentActivity, AtomicOperation.TRANSITION_END_ACTIVITY);
        } else {
            propagatingExecution.performAtomicOperation(AtomicOperation.TRANSITION_TAKE);
        }
    }

    @Override
    public MessageImpl<?> createAsyncMessage(ExecutionImpl execution) {
        throw new UnsupportedOperationException("please implement me");
    }

    public String toString() {
        return "TransitionEndActivity";
    }
}

