/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.tx.jta;

import javax.transaction.UserTransaction;
import org.jbpm.api.cmd.Command;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.svc.RetryInterceptor;
import org.jbpm.pvm.internal.tx.jta.JtaTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JtaRetryInterceptor
extends RetryInterceptor {
    private static Log log = Log.getLog((String)JtaRetryInterceptor.class.getName());

    @Override
    public <T> T execute(Command<T> command) {
        JtaTransaction jtaTransaction = EnvironmentImpl.getFromCurrent(JtaTransaction.class);
        UserTransaction userTransaction = jtaTransaction.lookupJeeUserTransaction();
        int status = JtaTransaction.getUserTransactionStatus(userTransaction);
        if (status == 6) {
            return this.executeWithRetry(command);
        }
        log.trace("transaction in progress.  skipping retry interceptor");
        return this.executeWithoutRetry(command);
    }

    public <T> T executeWithRetry(Command<T> command) {
        return super.execute(command);
    }

    public <T> T executeWithoutRetry(Command<T> command) {
        return this.next.execute(command);
    }
}

