/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.bpm;

import java.util.Map;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.mule.DefaultMuleEvent;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.ConnectorException;
import org.mule.config.i18n.MessageFactory;
import org.mule.session.DefaultMuleSession;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.bpm.ProcessConnector;

public class ProcessMessageReceiver
extends AbstractMessageReceiver {
    private ProcessConnector connector = null;

    public ProcessMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.connector = (ProcessConnector)connector;
    }

    public MuleMessage generateSynchronousEvent(String endpoint, Object payload, Map messageProperties) throws MuleException {
        this.logger.debug((Object)("Executing process is sending an event (synchronously) to Mule endpoint = " + endpoint));
        MuleMessage response = this.generateEvent(endpoint, payload, messageProperties, MessageExchangePattern.REQUEST_RESPONSE);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Synchronous response is " + (response != null ? response.getPayload() : null)));
        }
        return response;
    }

    public void generateAsynchronousEvent(String endpoint, Object payload, Map messageProperties) throws MuleException, WorkException {
        this.logger.debug((Object)("Executing process is dispatching an event (asynchronously) to Mule endpoint = " + endpoint));
        WorkManager workManager = this.getWorkManager();
        if (workManager == null) {
            throw new ConnectorException(MessageFactory.createStaticMessage("WorkManager not available"), this.getConnector());
        }
        workManager.scheduleWork(new Worker(endpoint, payload, messageProperties));
    }

    protected MuleMessage generateEvent(String endpoint, Object payload, Map messageProperties, MessageExchangePattern exchangePattern) throws MuleException {
        MuleMessage message = payload instanceof MuleMessage ? (MuleMessage)payload : this.createMuleMessage(payload, this.endpoint.getEncoding());
        message.addProperties(messageProperties);
        MuleMessage response = null;
        if (this.connector.isAllowGlobalDispatcher()) {
            EndpointBuilder endpointBuilder = this.connector.getMuleContext().getRegistry().lookupEndpointFactory().getEndpointBuilder(endpoint);
            endpointBuilder.setExchangePattern(exchangePattern);
            OutboundEndpoint ep = endpointBuilder.buildOutboundEndpoint();
            DefaultMuleEvent event = new DefaultMuleEvent(message, ep, new DefaultMuleSession(this.flowConstruct, this.connector.getMuleContext()));
            if (exchangePattern.hasResponse()) {
                MuleEvent resultEvent = ep.process(event);
                if (resultEvent != null) {
                    return resultEvent.getMessage();
                }
                return null;
            }
            ep.process(event);
        } else {
            message.setOutboundProperty("MULE_BPM_ENDPOINT", endpoint);
            MuleEvent event = this.routeMessage(message);
            MuleMessage muleMessage = response = event == null ? null : event.getMessage();
        }
        if (response != null && response.getExceptionPayload() != null) {
            throw new ConnectorException(MessageFactory.createStaticMessage("Unable to send or route message"), this.getConnector(), response.getExceptionPayload().getRootException());
        }
        return response;
    }

    private class Worker
    implements Work {
        private String endpoint;
        private Object payload;
        private Map messageProperties;

        public Worker(String endpoint, Object payload, Map messageProperties) {
            this.endpoint = endpoint;
            this.payload = payload;
            this.messageProperties = messageProperties;
        }

        public void run() {
            try {
                ProcessMessageReceiver.this.generateEvent(this.endpoint, this.payload, this.messageProperties, MessageExchangePattern.ONE_WAY);
            }
            catch (Exception e) {
                ProcessMessageReceiver.this.getConnector().getMuleContext().getExceptionListener().handleException(e);
            }
        }

        public void release() {
        }
    }
}

