/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.text.MessageFormat;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.transport.jms.AbstractRedeliveryHandler;
import org.mule.transport.jms.MessageRedeliveredException;
import org.mule.transport.jms.i18n.JmsMessages;

public class JmsXRedeliveryHandler
extends AbstractRedeliveryHandler {
    protected static final Log logger = LogFactory.getLog(JmsXRedeliveryHandler.class);

    public void handleRedelivery(Message message) throws JMSException, MuleException {
        int connectorRedelivery = this.connector.getMaxRedelivery();
        if (connectorRedelivery == -1 || connectorRedelivery < 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"We were asked to ignore the redelivery count, nothing to do here.");
            }
            return;
        }
        String messageId = message.getJMSMessageID();
        int deliveryCount = -1;
        try {
            deliveryCount = message.getIntProperty("JMSXDeliveryCount");
        }
        catch (NumberFormatException nex) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)String.format("Invalid use of %s. Message is flagged with JMSRedelivered, but JMSXDeliveryCount is not set", this.getClass().getName())));
        }
        int redeliveryCount = deliveryCount - 1;
        if (redeliveryCount == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message with id: " + messageId + " has been redelivered for the first time"));
            }
            if (connectorRedelivery == 0) {
                MuleMessage msg = this.createMuleMessage(message);
                throw new MessageRedeliveredException(JmsMessages.tooManyRedeliveries(messageId, String.valueOf(redeliveryCount), connectorRedelivery, this.connector.getName()), msg);
            }
        } else {
            if (redeliveryCount > connectorRedelivery) {
                logger.debug((Object)MessageFormat.format("Message with id: {0} has been redelivered {1} times, which exceeds the maxRedelivery setting of {2} on the connector {3}", messageId, redeliveryCount, connectorRedelivery, this.connector.getName()));
                MuleMessage msg = this.createMuleMessage(message);
                throw new MessageRedeliveredException(JmsMessages.tooManyRedeliveries(messageId, String.valueOf(redeliveryCount), connectorRedelivery, this.connector.getName()), msg);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Message with id: " + messageId + " has been redelivered " + redeliveryCount + " times"));
            }
        }
    }
}

