/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap.axis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.axis.AxisProperties;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis.wsdl.fromJava.Types;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.DispatchException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.NullPayload;
import org.mule.transport.soap.axis.AxisConnector;
import org.mule.transport.soap.axis.NamedParameter;
import org.mule.transport.soap.axis.SoapMethod;
import org.mule.transport.soap.axis.i18n.AxisMessages;
import org.mule.util.BeanUtils;
import org.mule.util.StringUtils;
import org.mule.util.TemplateParser;

public class AxisMessageDispatcher
extends AbstractMessageDispatcher {
    protected EngineConfiguration clientConfig;
    protected AxisConnector connector;
    protected Service service;
    private Map callParameters;

    public AxisMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (AxisConnector)endpoint.getConnector();
        AxisProperties.setProperty((String)"axis.doAutoTypes", (String)Boolean.toString(this.connector.isDoAutoTypes()));
    }

    protected void doConnect() throws Exception {
        if (this.service == null) {
            this.service = this.createService(this.endpoint);
        }
    }

    protected void doDisconnect() throws Exception {
        if (this.service != null) {
            this.service = null;
        }
    }

    protected void doDispose() {
    }

    protected synchronized EngineConfiguration getClientConfig(ImmutableEndpoint endpoint) {
        if (this.clientConfig == null) {
            String config = (String)endpoint.getProperty((Object)"clientConfig");
            this.clientConfig = config != null ? new FileProvider(config) : this.connector.getClientProvider();
        }
        return this.clientConfig;
    }

    protected Service createService(ImmutableEndpoint endpoint) throws Exception {
        EngineConfiguration config = this.getClientConfig(endpoint);
        return new Service(config);
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        Object[] args = this.getArgs(event);
        Call call = this.getCall(event, args);
        call.setProperty("axis.one.way", (Object)Boolean.TRUE);
        call.setProperty("MULE_EVENT", (Object)event);
        call.setProperty("mule.context", (Object)this.connector.getMuleContext());
        call.invoke(args);
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        Object[] args = this.getArgs(event);
        Call call = this.getCall(event, args);
        Object result = call.invoke(args);
        if (result == null) {
            return new DefaultMuleMessage((Object)NullPayload.getInstance(), this.connector.getMuleContext());
        }
        DefaultMuleMessage resultMessage = new DefaultMuleMessage(result, event.getMessage(), event.getMuleContext());
        this.setMessageContextProperties((MuleMessage)resultMessage, call.getMessageContext());
        return resultMessage;
    }

    protected Call getCall(MuleEvent event, Object[] args) throws Exception {
        EndpointURI endpointUri = event.getEndpoint().getEndpointURI();
        Object method = this.getInitialMethod(event);
        Call call = (Call)this.service.createCall();
        this.parseStyle(event, call);
        this.parseUse(event, call);
        BeanUtils.populateWithoutFail((Object)call, (Map)event.getEndpoint().getProperties(), (boolean)false);
        call.setTargetEndpointAddress(endpointUri.getAddress());
        method = this.refineMethod(event, call, method);
        String methodNamespace = call.getOperationName().getNamespaceURI();
        call.setProperty("MULE_EVENT", (Object)event);
        call.setProperty("MULE_ENDPOINT", (Object)event.getEndpoint());
        call.setProperty("mule.context", (Object)this.connector.getMuleContext());
        this.setCustomProperties(event, call);
        call.setTimeout(new Integer(event.getTimeout()));
        this.setUserCredentials(endpointUri, call);
        Map methodCalls = (Map)event.getMessage().getOutboundProperty("soapMethods");
        if (methodCalls == null && !(method instanceof SoapMethod)) {
            this.buildSoapMethods(event, call, method, methodNamespace, args);
        }
        this.setCallParams(call, event, call.getOperationName());
        this.setSoapAction(event, endpointUri, call);
        this.addAttachments(event, call);
        return call;
    }

    protected void addAttachments(MuleEvent event, Call call) {
        for (String name : event.getMessage().getAttachmentNames()) {
            DataHandler dh = event.getMessage().getAttachment(name);
            AttachmentPart part = new AttachmentPart(dh);
            call.addAttachmentPart((Object)part);
        }
    }

    protected void setSoapAction(MuleEvent event, EndpointURI endpointUri, Call call) {
        String soapAction = (String)event.getMessage().getOutboundProperty("soapAction");
        if (soapAction != null) {
            soapAction = this.parseSoapAction(soapAction, call.getOperationName(), event);
            call.setSOAPActionURI(soapAction);
            call.setUseSOAPAction(true);
        } else {
            call.setSOAPActionURI(endpointUri.getAddress());
        }
    }

    protected void buildSoapMethods(MuleEvent event, Call call, Object method, String methodNamespace, Object[] args) {
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            QName qname;
            if (args[i] == null) {
                qname = call.getTypeMapping().getTypeQName(Object.class);
                params.add(String.format("value%d;qname{%s:%s:%s};in", i, qname.getPrefix(), qname.getLocalPart(), qname.getNamespaceURI()));
                continue;
            }
            if (args[i] instanceof DataHandler[]) {
                params.add("attachments;qname{DataHandler:http://xml.apache.org/xml-soap};in");
                continue;
            }
            if (args[i] instanceof Map && this.connector.isTreatMapAsNamedParams()) {
                for (Map.Entry entry : ((Map)args[i]).entrySet()) {
                    if (call.getTypeMapping().getTypeQName(entry.getValue().getClass()) != null) {
                        QName type = call.getTypeMapping().getTypeQName(entry.getValue().getClass());
                        params.add(String.format("qname{%s%s};qname{%s:%s:%s};in", entry.getKey().toString(), methodNamespace == null ? "" : ":" + methodNamespace, type.getPrefix(), type.getLocalPart(), type.getNamespaceURI()));
                        continue;
                    }
                    params.add(String.format("value%d;qname{%s:%s};in", i, Types.getLocalNameFromFullName((String)args[i].getClass().getName()), Namespaces.makeNamespace((String)args[i].getClass().getName())));
                    params.add(String.format("qname{%s%s};qname{%s:%s};in", entry.getKey().toString(), methodNamespace == null ? "" : ":" + methodNamespace, Types.getLocalNameFromFullName((String)args[i].getClass().getName()), Namespaces.makeNamespace((String)args[i].getClass().getName())));
                }
                continue;
            }
            if (call.getTypeMapping().getTypeQName(args[i].getClass()) != null) {
                qname = call.getTypeMapping().getTypeQName(args[i].getClass());
                params.add(String.format("value%d;qname{%s:%s:%s};in", i, qname.getPrefix(), qname.getLocalPart(), qname.getNamespaceURI()));
                continue;
            }
            params.add(String.format("value%d;qname{%s:%s};in", i, Types.getLocalNameFromFullName((String)args[i].getClass().getName()), Namespaces.makeNamespace((String)args[i].getClass().getName())));
        }
        HashMap<Object, ArrayList<String>> map = new HashMap<Object, ArrayList<String>>();
        map.put(method, params);
        event.getMessage().setOutboundProperty("soapMethods", map);
    }

    protected void setUserCredentials(EndpointURI endpointUri, Call call) {
        if (endpointUri.getUserInfo() != null) {
            call.setUsername(endpointUri.getUser());
            call.setPassword(endpointUri.getPassword());
        }
    }

    protected void setCustomProperties(MuleEvent event, Call call) {
        for (String key : event.getMessage().getOutboundPropertyNames()) {
            Object value;
            if (key.startsWith("MULE_") || (value = event.getMessage().getOutboundProperty(key)) == null) continue;
            call.setProperty(key, value);
        }
    }

    protected Object refineMethod(MuleEvent event, Call call, Object method) {
        if (method instanceof String) {
            String methodNamespace = (String)event.getMessage().getOutboundProperty("methodNamespace");
            if (methodNamespace != null) {
                call.setOperationName(new QName(methodNamespace, method.toString()));
            } else {
                call.setOperationName(new QName(method.toString()));
            }
        } else if (method instanceof QName) {
            call.setOperationName((QName)method);
            method = ((QName)method).getLocalPart();
        } else {
            call.setOperationName(((SoapMethod)method).getName());
        }
        return method;
    }

    protected void parseUse(MuleEvent event, Call call) {
        String use = (String)event.getMessage().getOutboundProperty("use");
        if (use != null) {
            Use u = Use.getUse((String)use);
            if (u == null) {
                throw new IllegalArgumentException(CoreMessages.valueIsInvalidFor((String)use, (String)"use").toString());
            }
            call.setOperationUse(u);
        }
    }

    protected void parseStyle(MuleEvent event, Call call) {
        String style = (String)event.getMessage().getOutboundProperty("style");
        if (style != null) {
            Style s = Style.getStyle((String)style);
            if (s == null) {
                throw new IllegalArgumentException(CoreMessages.valueIsInvalidFor((String)style, (String)"style").toString());
            }
            call.setOperationStyle(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getInitialMethod(MuleEvent event) throws DispatchException {
        Object method = event.getMessage().getOutboundProperty("method");
        if (method == null) {
            method = event.getEndpoint().getEndpointURI().getParams().getProperty("method");
        }
        if (method == null) {
            throw new DispatchException(AxisMessages.cannotInvokeCallWithoutOperation(), event, (MessageProcessor)this);
        }
        if (method instanceof SoapMethod) {
            AxisMessageDispatcher axisMessageDispatcher = this;
            synchronized (axisMessageDispatcher) {
                if (this.callParameters == null) {
                    this.callParameters = new HashMap();
                }
                this.callParameters.put(((SoapMethod)method).getName().getLocalPart(), method);
            }
        }
        return method;
    }

    private Object[] getArgs(MuleEvent event) throws TransformerException {
        Object payload = event.getMessage().getPayload();
        Object[] args = payload instanceof Object[] ? (Object[])payload : new Object[]{payload};
        if (event.getMessage().getAttachmentNames() != null && event.getMessage().getAttachmentNames().size() > 0) {
            ArrayList<DataHandler> attachments = new ArrayList<DataHandler>();
            Iterator i = event.getMessage().getAttachmentNames().iterator();
            while (i.hasNext()) {
                attachments.add(event.getMessage().getAttachment((String)i.next()));
            }
            ArrayList<Object> temp = new ArrayList<Object>(Arrays.asList(args));
            temp.add(attachments.toArray(new DataHandler[0]));
            args = temp.toArray();
        }
        return args;
    }

    protected void setMessageContextProperties(MuleMessage message, MessageContext ctx) {
        String temp = ctx.getStrProp("MULE_CORRELATION_ID");
        if (StringUtils.isNotBlank((String)temp)) {
            message.setCorrelationId(temp);
        }
        if (StringUtils.isNotBlank((String)(temp = ctx.getStrProp("MULE_CORRELATION_GROUP_SIZE")))) {
            message.setCorrelationGroupSize(Integer.parseInt(temp));
        }
        if (StringUtils.isNotBlank((String)(temp = ctx.getStrProp("MULE_CORRELATION_SEQUENCE")))) {
            message.setCorrelationSequence(Integer.parseInt(temp));
        }
        if (StringUtils.isNotBlank((String)(temp = ctx.getStrProp("MULE_REPLYTO")))) {
            message.setReplyTo((Object)temp);
        }
    }

    protected void setMessageContextAttachments(MuleMessage message, MessageContext ctx) throws Exception {
        int x = 0;
        Iterator iterator = ctx.getMessage().getAttachments();
        while (iterator.hasNext()) {
            message.addAttachment(String.valueOf(x), ((AttachmentPart)iterator.next()).getActivationDataHandler());
            ++x;
        }
    }

    protected static MuleMessage createMessage(Object result, Call call, MuleContext muleContext) {
        if (result == null) {
            result = NullPayload.getInstance();
        }
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        Iterator iter = call.getMessageContext().getPropertyNames();
        while (iter.hasNext()) {
            Object key = iter.next();
            props.put(key, call.getMessageContext().getProperty(key.toString()));
        }
        props.put("soap.message", call.getMessageContext().getMessage());
        call.clearHeaders();
        call.clearOperation();
        return new DefaultMuleMessage(result, props, muleContext);
    }

    public String parseSoapAction(String soapAction, QName method, MuleEvent event) {
        EndpointURI endpointURI = event.getEndpoint().getEndpointURI();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        MuleMessage msg = event.getMessage();
        for (String propertyKey : msg.getOutboundPropertyNames()) {
            Object value = msg.getOutboundProperty(propertyKey);
            properties.put(propertyKey, value);
        }
        properties.put("method", method.getLocalPart());
        properties.put("methodNamespace", method.getNamespaceURI());
        properties.put("address", endpointURI.getAddress());
        properties.put("scheme", endpointURI.getScheme());
        properties.put("host", endpointURI.getHost());
        properties.put("port", String.valueOf(endpointURI.getPort()));
        properties.put("path", endpointURI.getPath());
        properties.put("hostInfo", endpointURI.getScheme() + "://" + endpointURI.getHost() + (endpointURI.getPort() > -1 ? ":" + String.valueOf(endpointURI.getPort()) : ""));
        if (event.getFlowConstruct() != null) {
            properties.put("serviceName", event.getFlowConstruct().getName());
        }
        TemplateParser tp = TemplateParser.createMuleStyleParser();
        soapAction = tp.parse(properties, soapAction);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("SoapAction for this call is: " + soapAction));
        }
        return soapAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCallParams(Call call, MuleEvent event, QName method) throws ClassNotFoundException {
        AxisMessageDispatcher axisMessageDispatcher = this;
        synchronized (axisMessageDispatcher) {
            if (this.callParameters == null) {
                this.loadCallParams(event, method.getNamespaceURI());
            }
        }
        SoapMethod soapMethod = (SoapMethod)event.getMessage().removeProperty("MULE_SOAP_METHOD");
        if (soapMethod == null) {
            soapMethod = (SoapMethod)this.callParameters.get(method.getLocalPart());
        }
        if (soapMethod != null) {
            for (NamedParameter parameter : soapMethod.getNamedParameters()) {
                call.addParameter(parameter.getName(), parameter.getType(), parameter.getMode());
            }
            if (soapMethod.getReturnType() != null) {
                call.setReturnType(soapMethod.getReturnType());
            } else if (soapMethod.getReturnClass() != null) {
                call.setReturnClass(soapMethod.getReturnClass());
            }
            call.setOperationName(soapMethod.getName());
        }
    }

    private void loadCallParams(MuleEvent event, String namespace) throws ClassNotFoundException {
        Map methodCalls = (Map)event.getMessage().getOutboundProperty("soapMethods");
        if (methodCalls == null) {
            return;
        }
        this.callParameters = new HashMap();
        for (Map.Entry entry : methodCalls.entrySet()) {
            SoapMethod soapMethod = StringUtils.isEmpty((String)namespace) ? (entry.getValue() instanceof List ? new SoapMethod(entry.getKey().toString(), (List)entry.getValue()) : new SoapMethod(entry.getKey().toString(), entry.getValue().toString())) : (entry.getValue() instanceof List ? new SoapMethod(new QName(namespace, entry.getKey().toString()), (List)entry.getValue()) : new SoapMethod(new QName(namespace, entry.getKey().toString()), entry.getValue().toString()));
            this.callParameters.put(soapMethod.getName().getLocalPart(), soapMethod);
        }
    }
}

