/*
 * Decompiled with CFR 0.152.
 */
package org.mule.client;

import java.util.HashMap;
import java.util.Map;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.client.DefaultLocalMuleClient;
import org.mule.tck.AbstractMuleTestCase;

public class DefaultLocalMuleClientTestCase
extends AbstractMuleTestCase {
    protected final String PROP_KEY_1 = "key1";
    protected final String TEST_URI = "test://test";
    protected final long TEST_RESPONSE_TIMEOUT = 567L;
    protected final long TEST_FREQ = 123L;
    protected final MessageExchangePattern TEST_MEP = MessageExchangePattern.ONE_WAY;
    protected TestableLocalMuleClient client;
    protected InboundEndpoint inboundEndpoint;
    protected OutboundEndpoint outboundEndpoint;
    protected Object messagePaylaod = "Test Message";
    protected Map<String, Object> messageProperties = new HashMap<String, Object>();
    protected MuleMessage message;
    protected MuleEvent responseEvent;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.client = new TestableLocalMuleClient(muleContext);
        this.messageProperties.put("key1", "val1");
        this.message = new DefaultMuleMessage(this.messagePaylaod, this.messageProperties, muleContext);
        this.outboundEndpoint = (OutboundEndpoint)Mockito.mock(OutboundEndpoint.class);
        this.inboundEndpoint = (InboundEndpoint)Mockito.mock(InboundEndpoint.class);
        this.responseEvent = DefaultLocalMuleClientTestCase.getTestEvent("RESPONSE");
    }

    public void testProcessOutboundEndpointObjectMapOfStringObject() throws MuleException {
        Mockito.stub((Object)this.outboundEndpoint.process((MuleEvent)Matchers.any(MuleEvent.class))).toReturn((Object)this.responseEvent);
        ArgumentCaptor argument = ArgumentCaptor.forClass(MuleEvent.class);
        MuleMessage response = this.client.process(this.outboundEndpoint, this.messagePaylaod, this.messageProperties);
        ((OutboundEndpoint)Mockito.verify((Object)this.outboundEndpoint)).process((MuleEvent)argument.capture());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.message.getPayload(), (Object)((MuleEvent)argument.getValue()).getMessage().getPayload());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.message.getOutboundProperty("key1"), (Object)((MuleEvent)argument.getValue()).getMessage().getOutboundProperty("key1"));
        DefaultLocalMuleClientTestCase.assertSame((Object)this.outboundEndpoint, (Object)((MuleEvent)argument.getValue()).getEndpoint());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.responseEvent.getMessage(), (Object)response);
    }

    public void testProcessOutboundEndpointMuleMessage() throws MuleException {
        Mockito.stub((Object)this.outboundEndpoint.process((MuleEvent)Matchers.any(MuleEvent.class))).toReturn((Object)this.responseEvent);
        ArgumentCaptor argument = ArgumentCaptor.forClass(MuleEvent.class);
        MuleMessage response = this.client.process(this.outboundEndpoint, this.message);
        ((OutboundEndpoint)Mockito.verify((Object)this.outboundEndpoint)).process((MuleEvent)argument.capture());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.message, (Object)((MuleEvent)argument.getValue()).getMessage());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.outboundEndpoint, (Object)((MuleEvent)argument.getValue()).getEndpoint());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.responseEvent.getMessage(), (Object)response);
    }

    public void testRequestInboundEndpointLong() throws Exception {
        Mockito.stub((Object)this.inboundEndpoint.request(Matchers.anyLong())).toReturn((Object)this.responseEvent.getMessage());
        MuleMessage result = this.client.request(this.inboundEndpoint, 567L);
        DefaultLocalMuleClientTestCase.assertSame((Object)this.responseEvent.getMessage(), (Object)result);
    }

    public void testDispatchStringObjectMapOfStringObject() throws MuleException {
        ArgumentCaptor argument = ArgumentCaptor.forClass(MuleEvent.class);
        this.client.dispatch("test://test", this.messagePaylaod, this.messageProperties);
        ((OutboundEndpoint)Mockito.verify((Object)this.outboundEndpoint)).process((MuleEvent)argument.capture());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.message.getPayload(), (Object)((MuleEvent)argument.getValue()).getMessage().getPayload());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.message.getOutboundProperty("key1"), (Object)((MuleEvent)argument.getValue()).getMessage().getOutboundProperty("key1"));
        DefaultLocalMuleClientTestCase.assertSame((Object)this.outboundEndpoint, (Object)((MuleEvent)argument.getValue()).getEndpoint());
    }

    public void testSendStringObjectMapOfStringObject() throws MuleException {
        Mockito.stub((Object)this.outboundEndpoint.process((MuleEvent)Matchers.any(MuleEvent.class))).toReturn((Object)this.responseEvent);
        ArgumentCaptor argument = ArgumentCaptor.forClass(MuleEvent.class);
        MuleMessage response = this.client.send("test://test", this.messagePaylaod, this.messageProperties);
        ((OutboundEndpoint)Mockito.verify((Object)this.outboundEndpoint)).process((MuleEvent)argument.capture());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.message.getPayload(), (Object)((MuleEvent)argument.getValue()).getMessage().getPayload());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.message.getOutboundProperty("key1"), (Object)((MuleEvent)argument.getValue()).getMessage().getOutboundProperty("key1"));
        DefaultLocalMuleClientTestCase.assertSame((Object)this.outboundEndpoint, (Object)((MuleEvent)argument.getValue()).getEndpoint());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.responseEvent.getMessage(), (Object)response);
    }

    public void testSendStringMuleMessage() throws MuleException {
        Mockito.stub((Object)this.outboundEndpoint.process((MuleEvent)Matchers.any(MuleEvent.class))).toReturn((Object)this.responseEvent);
        ArgumentCaptor argument = ArgumentCaptor.forClass(MuleEvent.class);
        MuleMessage response = this.client.send("test://test", this.message);
        ((OutboundEndpoint)Mockito.verify((Object)this.outboundEndpoint)).process((MuleEvent)argument.capture());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.message, (Object)((MuleEvent)argument.getValue()).getMessage());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.outboundEndpoint, (Object)((MuleEvent)argument.getValue()).getEndpoint());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.responseEvent.getMessage(), (Object)response);
    }

    public void testSendStringObjectMapOfStringObjectInt() throws MuleException {
        Mockito.stub((Object)this.outboundEndpoint.process((MuleEvent)Matchers.any(MuleEvent.class))).toReturn((Object)this.responseEvent);
        ArgumentCaptor argument = ArgumentCaptor.forClass(MuleEvent.class);
        MuleMessage response = this.client.send("test://test", this.messagePaylaod, this.messageProperties, 567L);
        ((OutboundEndpoint)Mockito.verify((Object)this.outboundEndpoint)).process((MuleEvent)argument.capture());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.message.getPayload(), (Object)((MuleEvent)argument.getValue()).getMessage().getPayload());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.message.getOutboundProperty("key1"), (Object)((MuleEvent)argument.getValue()).getMessage().getOutboundProperty("key1"));
        DefaultLocalMuleClientTestCase.assertSame((Object)this.outboundEndpoint, (Object)((MuleEvent)argument.getValue()).getEndpoint());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.responseEvent.getMessage(), (Object)response);
    }

    public void testSendStringMuleMessageInt() throws MuleException {
        Mockito.stub((Object)this.outboundEndpoint.process((MuleEvent)Matchers.any(MuleEvent.class))).toReturn((Object)this.responseEvent);
        ArgumentCaptor argument = ArgumentCaptor.forClass(MuleEvent.class);
        MuleMessage response = this.client.send("test://test", this.message, 567L);
        ((OutboundEndpoint)Mockito.verify((Object)this.outboundEndpoint)).process((MuleEvent)argument.capture());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.message, (Object)((MuleEvent)argument.getValue()).getMessage());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.outboundEndpoint, (Object)((MuleEvent)argument.getValue()).getEndpoint());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.responseEvent.getMessage(), (Object)response);
    }

    public void testDispatchStringMuleMessage() throws MuleException {
        ArgumentCaptor argument = ArgumentCaptor.forClass(MuleEvent.class);
        this.client.dispatch("test://test", this.message);
        ((OutboundEndpoint)Mockito.verify((Object)this.outboundEndpoint)).process((MuleEvent)argument.capture());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.message, (Object)((MuleEvent)argument.getValue()).getMessage());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.outboundEndpoint, (Object)((MuleEvent)argument.getValue()).getEndpoint());
    }

    public void testRequestStringLong() throws Exception {
        Mockito.stub((Object)this.inboundEndpoint.request(Matchers.anyLong())).toReturn((Object)this.responseEvent.getMessage());
        MuleMessage result = this.client.request("test://test", 567L);
        DefaultLocalMuleClientTestCase.assertSame((Object)this.responseEvent.getMessage(), (Object)result);
    }

    public void testProcessStringMessageExchangePatternObjectMapOfStringObject() throws MuleException {
        Mockito.stub((Object)this.outboundEndpoint.process((MuleEvent)Matchers.any(MuleEvent.class))).toReturn((Object)this.responseEvent);
        ArgumentCaptor argument = ArgumentCaptor.forClass(MuleEvent.class);
        MuleMessage response = this.client.send("test://test", this.messagePaylaod, this.messageProperties, 567L);
        ((OutboundEndpoint)Mockito.verify((Object)this.outboundEndpoint)).process((MuleEvent)argument.capture());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.message.getPayload(), (Object)((MuleEvent)argument.getValue()).getMessage().getPayload());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.message.getOutboundProperty("key1"), (Object)((MuleEvent)argument.getValue()).getMessage().getOutboundProperty("key1"));
        DefaultLocalMuleClientTestCase.assertSame((Object)this.outboundEndpoint, (Object)((MuleEvent)argument.getValue()).getEndpoint());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.responseEvent.getMessage(), (Object)response);
    }

    public void testProcessStringMessageExchangePatternMuleMessage() throws MuleException {
        Mockito.stub((Object)this.outboundEndpoint.process((MuleEvent)Matchers.any(MuleEvent.class))).toReturn((Object)this.responseEvent);
        ArgumentCaptor argument = ArgumentCaptor.forClass(MuleEvent.class);
        MuleMessage response = this.client.send("test://test", this.message, 567L);
        ((OutboundEndpoint)Mockito.verify((Object)this.outboundEndpoint)).process((MuleEvent)argument.capture());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.message, (Object)((MuleEvent)argument.getValue()).getMessage());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.outboundEndpoint, (Object)((MuleEvent)argument.getValue()).getEndpoint());
        DefaultLocalMuleClientTestCase.assertSame((Object)this.responseEvent.getMessage(), (Object)response);
    }

    public void testInboundEndpointCreation() throws MuleException {
        InboundEndpoint endpoint = this.client.createInboundEndpoint("test://test", this.TEST_MEP);
        DefaultLocalMuleClientTestCase.assertEquals((String)"test://test", (String)endpoint.getEndpointURI().getUri().toString());
        DefaultLocalMuleClientTestCase.assertEquals((Object)this.TEST_MEP, (Object)endpoint.getExchangePattern());
    }

    public void testOutboundEndpointCreation() throws MuleException {
        OutboundEndpoint endpoint = this.client.createOutboundEndpoint("test://test", this.TEST_MEP, new Long(567L));
        DefaultLocalMuleClientTestCase.assertEquals((String)"test://test", (String)endpoint.getEndpointURI().getUri().toString());
        DefaultLocalMuleClientTestCase.assertEquals((Object)this.TEST_MEP, (Object)endpoint.getExchangePattern());
        DefaultLocalMuleClientTestCase.assertEquals((long)567L, (long)endpoint.getResponseTimeout());
    }

    class TestableLocalMuleClient
    extends DefaultLocalMuleClient {
        public TestableLocalMuleClient(MuleContext muleContext) {
            super(muleContext);
        }

        InboundEndpoint createInboundEndpoint(String uri, MessageExchangePattern mep) throws MuleException {
            return super.getInboundEndpoint(uri, mep);
        }

        OutboundEndpoint createOutboundEndpoint(String uri, MessageExchangePattern mep, Long responseTimeout) throws MuleException {
            return super.getOutboundEndpoint(uri, mep, responseTimeout);
        }

        protected InboundEndpoint getInboundEndpoint(String uri, MessageExchangePattern mep) throws MuleException {
            return DefaultLocalMuleClientTestCase.this.inboundEndpoint;
        }

        protected OutboundEndpoint getOutboundEndpoint(String uri, MessageExchangePattern mep, Long responseTimeout) throws MuleException {
            return DefaultLocalMuleClientTestCase.this.outboundEndpoint;
        }
    }
}

