/*
 * Decompiled with CFR 0.152.
 */
package org.mule.component;

import org.mule.api.DefaultMuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.Callable;
import org.mule.api.object.ObjectFactory;
import org.mule.component.AbstractComponentTestCase;
import org.mule.component.SimpleCallableJavaComponent;
import org.mule.object.PrototypeObjectFactory;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Orange;

public class SimpleCallableJavaComponentTestCase
extends AbstractComponentTestCase {
    public void testComponentCreationWithObjectFactory() throws Exception {
        PrototypeObjectFactory objectFactory = new PrototypeObjectFactory(Apple.class);
        objectFactory.setObjectClass(Apple.class);
        objectFactory.initialise();
        SimpleCallableJavaComponent component = new SimpleCallableJavaComponent((ObjectFactory)objectFactory);
        SimpleCallableJavaComponentTestCase.assertNotNull((Object)component.getObjectFactory());
        SimpleCallableJavaComponentTestCase.assertEquals((Object)objectFactory, (Object)component.getObjectFactory());
        SimpleCallableJavaComponentTestCase.assertEquals(Apple.class, (Object)component.getObjectFactory().getObjectClass());
        SimpleCallableJavaComponentTestCase.assertEquals(Apple.class, (Object)component.getObjectType());
        objectFactory = new PrototypeObjectFactory(Orange.class);
        objectFactory.setObjectClass(Orange.class);
        objectFactory.initialise();
        try {
            component = new SimpleCallableJavaComponent((ObjectFactory)objectFactory);
        }
        catch (Exception e) {
            SimpleCallableJavaComponentTestCase.assertSame(DefaultMuleException.class, e.getClass());
        }
    }

    public void testDirectComponentCreation() throws Exception {
        SimpleCallableJavaComponent component = new SimpleCallableJavaComponent(Apple.class);
        SimpleCallableJavaComponentTestCase.assertNotNull((Object)component.getObjectFactory());
        SimpleCallableJavaComponentTestCase.assertEquals(Apple.class, (Object)component.getObjectFactory().getObjectClass());
        SimpleCallableJavaComponentTestCase.assertEquals(Apple.class, (Object)component.getObjectType());
        try {
            component = new SimpleCallableJavaComponent(Orange.class);
        }
        catch (Exception e) {
            SimpleCallableJavaComponentTestCase.assertSame(DefaultMuleException.class, e.getClass());
        }
    }

    public void testSimpleComponentCreation() throws Exception {
        SimpleCallableJavaComponent component = new SimpleCallableJavaComponent((Callable)new Apple());
        SimpleCallableJavaComponentTestCase.assertNotNull((Object)component.getObjectFactory());
        SimpleCallableJavaComponentTestCase.assertEquals(Apple.class, (Object)component.getObjectFactory().getObjectClass());
        SimpleCallableJavaComponentTestCase.assertEquals(Apple.class, (Object)component.getObjectType());
        try {
            component = new SimpleCallableJavaComponent((Callable)new Orange());
        }
        catch (Exception e) {
            SimpleCallableJavaComponentTestCase.assertSame(DefaultMuleException.class, e.getClass());
        }
    }

    public void testLifecycle() throws Exception {
        SimpleCallableJavaComponent component = new SimpleCallableJavaComponent((Callable)new Apple());
        component.setFlowConstruct((FlowConstruct)SimpleCallableJavaComponentTestCase.getTestService());
        component.initialise();
        component.start();
        SimpleCallableJavaComponentTestCase.assertNull((Object)component.borrowComponentLifecycleAdaptor());
        Object obj = component.getObjectFactory().getInstance(muleContext);
        SimpleCallableJavaComponentTestCase.assertNotNull((Object)obj);
        component.stop();
        component.dispose();
    }
}

