/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.routing.filters.MessagePropertyFilter;
import org.mule.tck.AbstractMuleTestCase;

public class MessagePropertyFilterTestCase
extends AbstractMuleTestCase {
    public void testMessagePropertyFilter() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo=bar");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        MessagePropertyFilterTestCase.assertTrue((!filter.accept((MuleMessage)message) ? 1 : 0) != 0);
        message.setOutboundProperty("foo", (Object)"bar");
        MessagePropertyFilterTestCase.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
    }

    public void testMessagePropertyFilterSessionScope() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        RequestContext.setEvent((MuleEvent)MessagePropertyFilterTestCase.getTestEvent(message));
        MessagePropertyFilter filter = new MessagePropertyFilter("foo=bar");
        filter.setScope("session");
        MessagePropertyFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)message));
        message.setSessionProperty("foo", (Object)"bar");
        MessagePropertyFilterTestCase.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
    }

    public void testMessagePropertyFilterInboundScope() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        RequestContext.setEvent((MuleEvent)MessagePropertyFilterTestCase.getTestEvent(message));
        MessagePropertyFilter filter = new MessagePropertyFilter("inbound:foo=bar");
        MessagePropertyFilterTestCase.assertEquals((String)"inbound", (String)filter.getScope());
        MessagePropertyFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)message));
        message.setInboundProperty("foo", (Object)"bar");
        MessagePropertyFilterTestCase.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
    }

    public void testMessagePropertyFilterWithURL() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        RequestContext.setEvent((MuleEvent)MessagePropertyFilterTestCase.getTestEvent(message));
        MessagePropertyFilter filter = new MessagePropertyFilter("inbound:foo=http://foo.com");
        MessagePropertyFilterTestCase.assertEquals((String)"inbound", (String)filter.getScope());
        MessagePropertyFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)message));
        message.setInboundProperty("foo", (Object)"http://foo.com");
        MessagePropertyFilterTestCase.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
        filter = new MessagePropertyFilter("bar=http://bar.com");
        MessagePropertyFilterTestCase.assertEquals((String)"outbound", (String)filter.getScope());
        MessagePropertyFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)message));
        message.setOutboundProperty("bar", (Object)"http://bar.com");
        MessagePropertyFilterTestCase.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
    }

    public void testMessagePropertyFilterWithNot() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo!=bar");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        MessagePropertyFilterTestCase.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
        message.setOutboundProperty("foo", (Object)"bar");
        MessagePropertyFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)message));
        message.setOutboundProperty("foo", (Object)"car");
        MessagePropertyFilterTestCase.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
    }

    public void testMessagePropertyFilterWithNotNull() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo!=null");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        MessagePropertyFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)message));
        message.removeProperty("foo");
        MessagePropertyFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)message));
        message.setOutboundProperty("foo", (Object)"car");
        MessagePropertyFilterTestCase.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
    }

    public void testMessagePropertyFilterWithCaseSensitivity() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo=Bar");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        message.setOutboundProperty("foo", (Object)"bar");
        MessagePropertyFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)message));
        filter.setCaseSensitive(false);
        MessagePropertyFilterTestCase.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
    }

    public void testMessagePropertyFilterWithWildcard() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo=B*");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        message.setOutboundProperty("foo", (Object)"bar");
        MessagePropertyFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)message));
        filter.setCaseSensitive(false);
        MessagePropertyFilterTestCase.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
        filter.setPattern("foo=*a*");
        MessagePropertyFilterTestCase.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
    }

    public void testMessagePropertyFilterDodgyValues() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter();
        MessagePropertyFilterTestCase.assertFalse((boolean)filter.accept(null));
        filter = new MessagePropertyFilter("foo = bar");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        message.setOutboundProperty("foo", (Object)"bar");
        MessagePropertyFilterTestCase.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
        filter.setCaseSensitive(false);
        filter = new MessagePropertyFilter("foo2 =null");
        message.removeProperty("foo2");
        MessagePropertyFilterTestCase.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
        filter = new MessagePropertyFilter("foo2 =");
        message.setOutboundProperty("foo2", (Object)"");
        MessagePropertyFilterTestCase.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
        message.removeProperty("foo2");
        MessagePropertyFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)message));
    }

    public void testMessagePropertyFilterPropertyExists() throws Exception {
        MessagePropertyFilter filter = new MessagePropertyFilter("foo!=null");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"blah", muleContext);
        MessagePropertyFilterTestCase.assertFalse((boolean)filter.accept((MuleMessage)message));
        message.setOutboundProperty("foo", (Object)"car");
        MessagePropertyFilterTestCase.assertTrue((String)"Filter didn't accept the message", (boolean)filter.accept((MuleMessage)message));
    }
}

