/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import org.mule.api.MuleMessage;
import org.mule.api.transport.MessageTypeNotSupportedException;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transport.NullPayload;

public abstract class AbstractMuleMessageFactoryTestCase
extends AbstractMuleTestCase {
    protected String encoding;
    protected boolean runUnsuppoprtedTransportMessageTest = true;

    public AbstractMuleMessageFactoryTestCase() {
        this.setStartContext(false);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.encoding = muleContext.getConfiguration().getDefaultEncoding();
    }

    public void testNullPayload() throws Exception {
        MuleMessageFactory factory = this.createMuleMessageFactory();
        MuleMessage message = factory.create(null, this.encoding);
        AbstractMuleMessageFactoryTestCase.assertNotNull((Object)message);
        AbstractMuleMessageFactoryTestCase.assertEquals((Object)NullPayload.getInstance(), (Object)message.getPayload());
    }

    public void testValidPayload() throws Exception {
        MuleMessageFactory factory = this.createMuleMessageFactory();
        Object payload = this.getValidTransportMessage();
        MuleMessage message = factory.create(payload, this.encoding);
        AbstractMuleMessageFactoryTestCase.assertNotNull((Object)message);
        AbstractMuleMessageFactoryTestCase.assertEquals((Object)payload, (Object)message.getPayload());
    }

    public void testUnsupportedPayloadType() throws Exception {
        if (!this.runUnsuppoprtedTransportMessageTest) {
            return;
        }
        MuleMessageFactory factory = this.createMuleMessageFactory();
        Object invalidPayload = this.getUnsupportedTransportMessage();
        try {
            factory.create(invalidPayload, this.encoding);
            AbstractMuleMessageFactoryTestCase.fail((String)"Creating a MuleMessageFactory from an invalid transport message must fail");
        }
        catch (MessageTypeNotSupportedException messageTypeNotSupportedException) {
            // empty catch block
        }
    }

    protected MuleMessageFactory createMuleMessageFactory() {
        MuleMessageFactory factory = this.doCreateMuleMessageFactory();
        AbstractMuleMessageFactoryTestCase.assertNotNull((Object)factory);
        return factory;
    }

    protected Object getUnsupportedTransportMessage() {
        throw new AssertionError((Object)"Subclasses must properly implement this method");
    }

    protected abstract MuleMessageFactory doCreateMuleMessageFactory();

    protected abstract Object getValidTransportMessage() throws Exception;
}

