/*
 * Decompiled with CFR 0.152.
 */
package org.mule.work;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import javax.resource.spi.work.Work;
import junit.framework.Assert;
import org.mule.DefaultMuleMessage;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.concurrent.Latch;
import org.mule.work.AbstractMuleEventWork;

public class MuleEventWorkTestCase
extends AbstractMuleTestCase {
    protected MuleEvent originalEvent;
    protected Latch latch = new Latch();

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.originalEvent = MuleEventWorkTestCase.getTestEvent("test");
        this.originalEvent.getMessage().setOutboundProperty("test", (Object)"val");
        this.originalEvent.getMessage().setOutboundProperty("test2", (Object)"val2");
        OptimizedRequestContext.unsafeSetEvent((MuleEvent)this.originalEvent);
    }

    public void testScheduleMuleEventWork() throws Exception {
        muleContext.getWorkManager().scheduleWork((Work)new TestMuleEventWork(this.originalEvent));
        MuleEventWorkTestCase.assertTrue((String)"Timed out waiting for latch", (boolean)this.latch.await(2000L, TimeUnit.MILLISECONDS));
        MuleEventWorkTestCase.assertSame((Object)this.originalEvent, (Object)RequestContext.getEvent());
        try {
            ((DefaultMuleMessage)this.originalEvent.getMessage()).assertAccess(true);
        }
        catch (Exception e) {
            MuleEventWorkTestCase.fail((String)e.getMessage());
        }
    }

    public void testRunMuleEventWork() throws Exception {
        new TestMuleEventWork(this.originalEvent).run();
        MuleEventWorkTestCase.assertNotSame((Object)this.originalEvent, (Object)RequestContext.getEvent());
        try {
            ((DefaultMuleMessage)this.originalEvent.getMessage()).assertAccess(true);
        }
        catch (Exception e) {
            MuleEventWorkTestCase.fail((String)e.getMessage());
        }
    }

    private class TestMuleEventWork
    extends AbstractMuleEventWork {
        public TestMuleEventWork(MuleEvent event) {
            super(event);
        }

        protected void doRun() {
            Assert.assertNotSame((String)"MuleEvent", (Object)this.event, (Object)MuleEventWorkTestCase.this.originalEvent);
            Assert.assertNotNull((String)"RequestContext.getEvent() is null", (Object)RequestContext.getEvent());
            try {
                ((DefaultMuleMessage)this.event.getMessage()).assertAccess(true);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            MuleEventWorkTestCase.this.latch.countDown();
        }
    }
}

