/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.activity;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.jpdl.internal.activity.HqlActivity;
import org.jbpm.jpdl.internal.activity.JpdlBinding;
import org.jbpm.jpdl.internal.xml.JpdlParser;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.descriptor.ListDescriptor;
import org.jbpm.pvm.internal.wire.xml.WireParser;
import org.jbpm.pvm.internal.xml.Parse;
import org.w3c.dom.Element;

public class HqlBinding
extends JpdlBinding {
    public static final String TAG = "hql";

    public HqlBinding() {
        super(TAG);
    }

    protected HqlBinding(String tagName) {
        super(tagName);
    }

    public Object parseJpdl(Element element, Parse parse, JpdlParser parser) {
        HqlActivity hqlActivity = this.createHqlActivity();
        Element queryElement = XmlUtil.element((Element)element, (String)"query", (boolean)true, (Parse)parse);
        if (queryElement != null) {
            String query = XmlUtil.getContentText((Element)queryElement);
            hqlActivity.setQuery(query);
        }
        if (XmlUtil.attributeBoolean((Element)element, (String)"unique", (boolean)false, (Parse)parse, (Boolean)Boolean.FALSE).booleanValue()) {
            hqlActivity.setResultUnique(true);
        }
        String variableName = XmlUtil.attribute((Element)element, (String)"var", (boolean)true, (Parse)parse);
        hqlActivity.setResultVariableName(variableName);
        Element parametersElement = XmlUtil.element((Element)element, (String)"parameters");
        List paramElements = XmlUtil.elements((Element)parametersElement);
        if (!paramElements.isEmpty()) {
            ArrayList<Descriptor> parametersDescriptor = new ArrayList<Descriptor>();
            for (Element paramElement : paramElements) {
                WireParser wireParser = WireParser.getInstance();
                Descriptor paramDescriptor = (Descriptor)wireParser.parseElement(paramElement, parse, "descriptor");
                parametersDescriptor.add(paramDescriptor);
            }
            ListDescriptor parametersListDescriptor = new ListDescriptor();
            parametersListDescriptor.setValueDescriptors(parametersDescriptor);
            hqlActivity.setParametersDescriptor(parametersListDescriptor);
        }
        return hqlActivity;
    }

    protected HqlActivity createHqlActivity() {
        return new HqlActivity();
    }
}

