/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.activity;

import java.util.List;
import org.jbpm.api.Execution;
import org.jbpm.api.JbpmException;
import org.jbpm.api.model.OpenExecution;
import org.jbpm.jpdl.internal.activity.JpdlAutomaticActivity;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.WireDefinition;
import org.jbpm.pvm.internal.wire.descriptor.ArgDescriptor;
import org.jbpm.pvm.internal.wire.descriptor.ObjectDescriptor;
import org.jbpm.pvm.internal.wire.usercode.UserCodeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaActivity
extends JpdlAutomaticActivity {
    private static final long serialVersionUID = 1L;
    protected UserCodeReference invocationReference;
    protected String methodName = null;
    protected List<ArgDescriptor> argDescriptors = null;
    protected String variableName;

    @Override
    public void perform(OpenExecution execution) throws Exception {
        Class<?> clazz;
        if (this.invocationReference == null) {
            throw new JbpmException("no target specified");
        }
        Object target = this.invocationReference.getObject((Execution)execution);
        if (target != null) {
            clazz = target.getClass();
        } else {
            ObjectDescriptor objectDescriptor = (ObjectDescriptor)this.invocationReference.getDescriptor();
            String className = objectDescriptor.getClassName();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            clazz = Class.forName(className, true, classLoader);
        }
        WireContext wireContext = new WireContext(new WireDefinition());
        Object returnValue = ObjectDescriptor.invokeMethod((String)this.methodName, this.argDescriptors, (WireContext)wireContext, (Object)target, clazz);
        if (this.variableName != null) {
            execution.setVariable(this.variableName, returnValue);
        }
    }

    public void setInvocationReference(UserCodeReference invocationReference) {
        this.invocationReference = invocationReference;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public List<ArgDescriptor> getArgDescriptors() {
        return this.argDescriptors;
    }

    public void setArgDescriptors(List<ArgDescriptor> argDescriptors) {
        this.argDescriptors = argDescriptors;
    }

    public UserCodeReference getInvocationReference() {
        return this.invocationReference;
    }

    public String getVariableName() {
        return this.variableName;
    }
}

