/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.internal.xml;

import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.util.TagBinding;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.xml.Binding;
import org.jbpm.pvm.internal.xml.Bindings;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class JpdlBindingsParser
extends Parser {
    private static final Log log = Log.getLog((String)JpdlBindingsParser.class.getName());

    public Object parseDocumentElement(Element documentElement, Parse parse) {
        Bindings bindings = (Bindings)parse.contextMapGet("bindings");
        parse.setDocumentObject((Object)bindings);
        for (Element bindingElement : XmlUtil.elements((Element)documentElement)) {
            Binding binding = this.instantiateBinding(bindingElement, parse);
            bindings.addBinding(binding);
        }
        return bindings;
    }

    protected Binding instantiateBinding(Element bindingElement, Parse parse) {
        String bindingClassName = XmlUtil.attribute((Element)bindingElement, (String)"binding", (boolean)true, (Parse)parse);
        log.trace("adding jpdl binding " + bindingClassName);
        if (bindingClassName != null) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> bindingClass = Class.forName(bindingClassName, true, classLoader);
                TagBinding binding = (TagBinding)bindingClass.newInstance();
                String tagLocalName = XmlUtil.getTagLocalName((Element)bindingElement);
                if ("activity".equals(tagLocalName)) {
                    binding.setCategory("activity");
                } else if ("eventlistener".equals(tagLocalName)) {
                    binding.setCategory("eventlistener");
                } else {
                    parse.addProblem("unrecognized binding tag: " + tagLocalName);
                }
                return binding;
            }
            catch (Exception e) {
                parse.addProblem("couldn't instantiate activity binding " + bindingClassName, e);
            }
        }
        return null;
    }
}

