/*
 * $Id: GroovyMessageBuilderTestCase.java 17313 2010-05-18 21:09:50Z aperepel $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.components.script;

import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;

public class GroovyMessageBuilderTestCase extends FunctionalTestCase
{

    protected String getConfigResources()
    {
        return "groovy-messagebuilder-config.xml";
    }

    public void testFunctionBehaviour() throws Exception
    {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage m = client.send("groovy1.endpoint", "Test:", null);
        assertNotNull(m);
        assertEquals("Test: A B Received", m.getPayloadAsString());
    }

}
