/*
 * $Id: JXPathTestCase.java 19145 2010-08-22 08:39:26Z mike.schilling $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.module.xml.functional;

import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;

public class JXPathTestCase extends FunctionalTestCase
{

    @Override
    protected String getConfigResources()
    {
        return "jxpath-config.xml";
    }

    public void testSetMessagePropertyFromXmlWithNamespacesDefinedWithSamePrefix() throws Exception
    {
        String xml = "<root " +
                     "xmlns:h=\"http://www.w3.org/TR/html4/\" " +
                     "xmlns:f=\"http://www.w3schools.com/furniture\">" +

                     "<h:table>" +
                     "<h:tr>" +
                     "<h:td>Apples</h:td>" +
                     "<h:td>Bananas</h:td>" +
                     "</h:tr>" +
                     "</h:table>" +

                     "<f:table>" +
                     "<f:name>African Coffee Table</f:name>" +
                     "<f:width>80</f:width>" +
                     "<f:length>120</f:length>" +
                     "</f:table>" +

                     "</root>";

        doTest(xml);
    }

    public void testSetMessagePropertyFromXmlWithNamespacesDefinedWithDifferentPrefix() throws Exception
    {
        String xml = "<root " +
                     "xmlns:h=\"http://www.w3.org/TR/html4/\" " +
                     "xmlns:z=\"http://www.w3schools.com/furniture\">" +

                     "<h:table>" +
                     "<h:tr>" +
                     "<h:td>Apples</h:td>" +
                     "<h:td>Bananas</h:td>" +
                     "</h:tr>" +
                     "</h:table>" +

                     "<z:table>" +
                     "<z:name>African Coffee Table</z:name>" +
                     "<z:width>80</z:width>" +
                     "<z:length>120</z:length>" +
                     "</z:table>" +

                     "</root>";

        doTest(xml);
    }

    private void doTest(String xml) throws MuleException
    {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage response = client.send("vm://in", xml, null);
        assertNotNull(response);
        assertNotNull(response.getProperty("nameProperty"));
        assertEquals("African Coffee Table", response.getProperty("nameProperty"));
    }
}

