/*
 * $Id: NoActionTransformer.java 18594 2010-07-27 17:20:13Z tcarlson $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tck.transformer;

import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

/**
 * <code>NoActionTransformer</code> doesn't do any transformation on the source
 * object and returns the source as the result. This can be used to overload the
 * default transform for an endpoint.
 */
public final class NoActionTransformer extends AbstractTransformer
{

    public NoActionTransformer()
    {
        registerSourceType(Object.class);
        setReturnDataType(DataTypeFactory.create(Object.class));
    }

    @Override
    public Object doTransform(Object src, String encoding) throws TransformerException
    {
        return src;
    }

    @Override
    public boolean isAcceptNull()
    {
        return true;
    }

}
