/*
 * $Id: AbstractMuleMessageFactoryTestCase.java 17177 2010-05-05 12:55:17Z dirk.olmes $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transport;

import org.mule.api.MuleMessage;
import org.mule.api.transport.MessageTypeNotSupportedException;
import org.mule.api.transport.MuleMessageFactory;
import org.mule.tck.AbstractMuleTestCase;

public abstract class AbstractMuleMessageFactoryTestCase extends AbstractMuleTestCase
{
    protected String encoding;
    
    /**
     * Subclasses can set this flag to false, disabling the test for unsupported transport
     * message types.
     */
    protected boolean runUnsuppoprtedTransportMessageTest = true;

    public AbstractMuleMessageFactoryTestCase()
    {
        super();
        setStartContext(false);
    }
    
    @Override
    protected void doSetUp() throws Exception
    {
        super.doSetUp();
        encoding = muleContext.getConfiguration().getDefaultEncoding();
    }
    
    public void testNullPayload() throws Exception
    {
        MuleMessageFactory factory = createMuleMessageFactory();
        
        MuleMessage message = factory.create(null, encoding);
        assertNotNull(message);
        assertEquals(NullPayload.getInstance(), message.getPayload());
    }

    public void testValidPayload() throws Exception
    {
        MuleMessageFactory factory = createMuleMessageFactory();
    
        Object payload = getValidTransportMessage();
        MuleMessage message = factory.create(payload, encoding);
        assertNotNull(message);
        assertEquals(payload, message.getPayload());
    }
    
    public void testUnsupportedPayloadType() throws Exception
    {
        if (runUnsuppoprtedTransportMessageTest == false)
        {
            return;
        }
        
        MuleMessageFactory factory = createMuleMessageFactory();
        
        Object invalidPayload = getUnsupportedTransportMessage();
        try
        {
            factory.create(invalidPayload, encoding);
            fail("Creating a MuleMessageFactory from an invalid transport message must fail"); 
        }
        catch (MessageTypeNotSupportedException mtnse)
        {
            // this one was expected
        }
    }

    protected MuleMessageFactory createMuleMessageFactory()
    {
        MuleMessageFactory factory = doCreateMuleMessageFactory();
        assertNotNull(factory);
        return factory;
    }

    protected Object getUnsupportedTransportMessage()
    {
        throw new AssertionError("Subclasses must properly implement this method");
    }

    protected abstract MuleMessageFactory doCreateMuleMessageFactory();
    
    protected abstract Object getValidTransportMessage() throws Exception;
}
