/*
 * $Id: ConnectableLifecycleManager.java 18162 2010-07-12 19:36:43Z aperepel $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.transport;

import org.mule.api.MuleException;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.LifecycleCallback;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.lifecycle.SimpleLifecycleManager;

/**
 * TODO
 */
public class ConnectableLifecycleManager<O> extends SimpleLifecycleManager<O>
{

    public ConnectableLifecycleManager(String id, O object)
    {
        super(id, object);
    }

    @Override
    public void fireInitialisePhase(LifecycleCallback<O> callback) throws MuleException
    {
        checkPhase(Initialisable.PHASE_NAME);
        if (logger.isInfoEnabled())
        {
            logger.info(String.format("Initialising: '%s'. Object is: %s", lifecycleManagerId, getLifecycleObject().getClass().getSimpleName()));
        }
        invokePhase(Initialisable.PHASE_NAME, getLifecycleObject(), callback);
    }

    @Override
    public void fireStartPhase(LifecycleCallback<O> callback) throws MuleException
    {
        checkPhase(Startable.PHASE_NAME);
        if (logger.isInfoEnabled())
        {
            logger.info(String.format("Starting: '%s'. Object is: %s", lifecycleManagerId, getLifecycleObject().getClass().getSimpleName()));
        }
        invokePhase(Startable.PHASE_NAME, getLifecycleObject(), callback);
    }

    @Override
    public void fireStopPhase(LifecycleCallback<O> callback) throws MuleException
    {
        checkPhase(Stoppable.PHASE_NAME);
        if (logger.isInfoEnabled())
        {
            logger.info(String.format("Stopping: '%s'. Object is: %s", lifecycleManagerId, getLifecycleObject().getClass().getSimpleName()));
        }
        invokePhase(Stoppable.PHASE_NAME, getLifecycleObject(), callback);
    }

    @Override
    public void fireDisposePhase(LifecycleCallback<O> callback) throws MuleException
    {
        checkPhase(Disposable.PHASE_NAME);
        if (logger.isInfoEnabled())
        {
            logger.info(String.format("Disposing: '%s'. Object is: %s", lifecycleManagerId, getLifecycleObject().getClass().getSimpleName()));
        }
        invokePhase(Disposable.PHASE_NAME, getLifecycleObject(), callback);
    }
}
