/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.bpm;

import java.util.HashMap;
import java.util.Map;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.DispatchException;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.MessageFactory;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.NullPayload;
import org.mule.transport.bpm.ProcessConnector;
import org.mule.util.StringUtils;

public class ProcessMessageDispatcher
extends AbstractMessageDispatcher {
    private ProcessConnector connector;

    public ProcessMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (ProcessConnector)endpoint.getConnector();
    }

    public MuleMessage doSend(MuleEvent event) throws Exception {
        Object process = this.processAction(event);
        if (process != null) {
            DefaultMuleMessage msg = new DefaultMuleMessage(process, this.connector.getMuleContext());
            msg.setProperty("MULE_BPM_PROCESS_ID", this.connector.getBpms().getId(process), PropertyScope.INVOCATION);
            return msg;
        }
        throw new DispatchException(MessageFactory.createStaticMessage("Synchronous process invocation must return the new process state."), event, (MessageProcessor)this);
    }

    public void doDispatch(MuleEvent event) throws Exception {
        this.processAction(event);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object processAction(MuleEvent event) throws Exception {
        Object process;
        void var5_14;
        Object t;
        HashMap<String, Object> processVariables = new HashMap<String, Object>();
        if (event != null) {
            this.populateProcessVariables(event, processVariables, PropertyScope.INVOCATION);
            this.populateProcessVariables(event, processVariables, PropertyScope.OUTBOUND);
            Object object = event.getMessage().getPayload();
            if (object != null && !(object instanceof NullPayload)) {
                processVariables.put("incoming", object);
                String string = (String)event.getMessage().getOutboundProperty("MULE_ORIGINATING_ENDPOINT");
                if (StringUtils.isNotEmpty((String)string)) {
                    processVariables.put("incomingSource", string);
                }
            }
        }
        Object t2 = event.getMessage().getInvocationProperty("MULE_BPM_PROCESS_TYPE");
        processVariables.remove("MULE_BPM_PROCESS_TYPE");
        String processIdField = this.connector.getProcessIdField();
        if (StringUtils.isNotEmpty((String)processIdField)) {
            Object t3 = event.getMessage().getInvocationProperty(processIdField);
        }
        if ((t = event.getMessage().getInvocationProperty("MULE_BPM_PROCESS_ID")) == null) {
            Object t4 = event.getMessage().getOutboundProperty("MULE_BPM_PROCESS_ID");
        }
        processVariables.remove("MULE_BPM_PROCESS_ID");
        String action = event.getMessage().getInvocationProperty("MULE_BPM_ACTION", "advance");
        processVariables.remove("MULE_BPM_ACTION");
        Object transition = event.getMessage().getInvocationProperty("MULE_BPM_TRANSITION");
        processVariables.remove("MULE_BPM_TRANSITION");
        String temp = event.getEndpoint().getEndpointURI().getHost();
        if (StringUtils.isNotEmpty((String)temp)) {
            String string = temp;
        }
        if (StringUtils.isNotEmpty((String)(temp = event.getEndpoint().getEndpointURI().getPath()))) {
            if (temp.startsWith("/")) {
                temp = StringUtils.right((String)temp, (int)(temp.length() - 1));
            }
            if (temp.indexOf("/") != -1) {
                throw new IllegalArgumentException("Unexpected format in the path of the URL: " + temp);
            }
            String string = temp;
        }
        if (var5_14 == null || action.equals("start")) {
            void var4_6;
            if (var4_6 == null) throw new IllegalArgumentException("Process type is missing, cannot start a new process.");
            process = this.connector.getBpms().startProcess(var4_6, transition, processVariables);
            if (process == null || !this.logger.isInfoEnabled()) return process;
            this.logger.info((Object)("New process started, ID = " + this.connector.getBpms().getId(process)));
            return process;
        } else if (action.equals("update")) {
            if (var5_14 == null) throw new IllegalArgumentException("Process ID is missing, cannot update process.");
            process = this.connector.getBpms().updateProcess(var5_14, processVariables);
            if (process == null || !this.logger.isInfoEnabled()) return process;
            this.logger.info((Object)("Process variables updated, ID = " + this.connector.getBpms().getId(process)));
            return process;
        } else if (action.equals("abort")) {
            if (var5_14 == null) throw new IllegalArgumentException("Process ID is missing, cannot abort process.");
            this.connector.getBpms().abortProcess(var5_14);
            process = NullPayload.getInstance();
            this.logger.info((Object)("Process aborted, ID = " + var5_14));
            return process;
        } else {
            if (var5_14 == null) throw new IllegalArgumentException("Process ID is missing, cannot advance process.");
            process = this.connector.getBpms().advanceProcess(var5_14, transition, processVariables);
            if (process == null || !this.logger.isInfoEnabled()) return process;
            this.logger.info((Object)("Process advanced, ID = " + this.connector.getBpms().getId(process) + ", new state = " + this.connector.getBpms().getState(process)));
        }
        return process;
    }

    protected void populateProcessVariables(MuleEvent event, Map processVariables, PropertyScope propertyScope) {
        for (String propertyName : event.getMessage().getPropertyNames(propertyScope)) {
            if (propertyName.equals("MULE_SESSION")) continue;
            processVariables.put(propertyName, event.getMessage().getProperty(propertyName, propertyScope));
        }
    }
}

